#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
from os.path import isfile, join
import argparse
import logging
import datetime
import sys

def argument_parser():
    parser = argparse.ArgumentParser(
       description="Utility to generate pools for each OPC/TWS table and fiil it with the variables and their values")
    parser.add_argument('-i', dest='input_file', type=str, default='', help='Extracted vartab from OPC/TWS on MF', metavar='')
    parser.add_argument('-log', dest='log', type=int, help=argparse.SUPPRESS, default=0, metavar='')
    parser.add_argument('-o', dest='output_file', type=str, help='File to hold add commands to add variables into pool', metavar='', default='output.bat')
    parser.add_argument('-e', dest='encoding', type=str, help='Encoding of the input file - Default is the local default encoding', metavar='', default='')
    return parser

def main():
    args = argument_parser().parse_args()
    if len(args.encoding) > 0:
        encoding = args.encoding
    else:
        encoding = sys.getdefaultencoding()
    
    generate_log_file(args.log)
    logging.info(get_time_stamp() + ' script parameters: ' + str(args))

    print ('input is: ' + args.input_file)
    print ('Output is: ' + args.output_file)
    print ('encoding: ' + encoding)

    with open(args.output_file, 'w', encoding=encoding) as output:
        with open(args.input_file, encoding=encoding) as file:
            line = file.readline()
            while line:
                logging.debug(get_time_stamp() + 'line - {}'.format(line))
                if "JCL VARIABLE TABLE ID" in line:
                    table_name = line.split(':')[1]
                    pool = table_name.strip().split(' ')[0]
                    logging.debug(get_time_stamp() + 'pool - {}'.format(pool))
                    line = file.readline()
                    if "VARIABLE NAME" in line:
                        line = file.readline()
                        variable = line.strip().split(' ')[0]
                        logging.debug(get_time_stamp() + 'variable - {}'.format(variable))
                        line = file.readline()
                        if "DEFAULT VALUE" in line:
                            try:
                                value = line.split(':')[1].strip()
                            except IndexError:
                                value = 'no_value_specified'
                                logging.info((get_time_stamp() + 'No value in line - *{}*'.format(line)))

                            logging.debug(get_time_stamp() + 'value - {}'.format(value))
                            output.write('ctmvar -pool setvar -poolname {} -var {} -value "{}"\n'.format(pool, variable, value))

                line = file.readline()    

def generate_log_file(log):
    dirpath = os.path.join(".\log")
    if not os.path.isdir(dirpath):
        os.makedirs(dirpath)
    path = os.path.join(dirpath, "var-pool.log")
    if log == 2 and os.path.exists(path):
        os.remove(path)
    if log == 0:
        logging.basicConfig(filename=path, level=logging.INFO)
    elif log == 1:
        logging.basicConfig(filename=path, level=logging.ERROR)
    elif log == 2:
        logging.basicConfig(filename=path, level=logging.DEBUG)

def get_time_stamp():
    return str(datetime.datetime.now()) + " "

if __name__ == "__main__":
    start = time.time()
    main()
    end = time.time()
    print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")