#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re


USAGE= "jaw-across.py -m <inputfile> -d <inputfile> -o <outputdir> [-c <comparedir>] "
def main(argv):
    input_mf_file =  'MF.XML'
    input_ds_file =  'DS.XML'
    output_dir = 'output'
    compare_dir = 'compare'

    try:
        opts, args = getopt.getopt(argv,"hc:m:d:o:",["mffile=","dsfile=","odir="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt == "-c":
            compare_dir = arg
        elif opt in ("-m", "--mffile"):
            input_mf_file = arg
        elif opt in ("-d", "--dsfile"):
            input_ds_file = arg
        elif opt in ("-o", "--odir"):
            output_dir= arg
    print ('Input file from MF is: ' + input_mf_file)
    print ('Input file from DS is: ' + input_ds_file)
    print ('Output dir is: ' + output_dir)
    if len(compare_dir) > 0:
        print ('Output dir is: ' + compare_dir)
    tree_mf = ET.parse(input_mf_file); print("Read the MF input file: " + input_mf_file)
    root_mf = tree_mf.getroot()
    tree_ds = ET.parse(input_ds_file); print("Read the DS input file: " + input_ds_file)
    root_ds = tree_ds.getroot()

    if len(compare_dir) > 0:
        tree_mf.write(compare_dir + "\\" + os.path.basename(input_mf_file));print("MF original saved for comparison.")
        tree_ds.write(compare_dir + "\\" + os.path.basename(input_ds_file));print("DS original saved for comparison.")


    process_all_folders(root_mf, root_ds)

    print("Writing updates to the XML file...")

    tree_mf.write(output_dir + "\\" + os.path.basename(input_mf_file));print("MF updates saved to the output XML file.")
    tree_ds.write(output_dir + "\\" + os.path.basename(input_ds_file));print("DS updates saved to the output XML file.")

def process_all_folders(root_mf, root_ds):
    folder_mf_dict = build_folder_dict(root_mf); print("Got all MF folders. Total: ", str(len(folder_mf_dict)))
    folder_ds_dict = build_folder_dict(root_ds); print("Got all DS folders. Total: ", str(len(folder_ds_dict)))
    folder_ds_handled = []
    for folder_name in folder_mf_dict.keys():
        folder_mf = folder_mf_dict.get(folder_name)
        folder_ds = folder_ds_dict.get(folder_name)
        # folder_ds_handled.append(folder_name)
        handle_folder_pair(folder_mf,folder_ds)
    # for folder_name in folder_ds_dict.keys():
    #     if folder_name not in folder_ds_handled:
    #         folder_ds = folder_ds_dict.get(folder_name)
    #         handle_folder_pair(None,folder_ds)

    # del_folder_out_cond(folder_mf_dict)
    # del_folder_out_cond(folder_ds_dict)
    return

def build_folder_dict(root):
    folder_dict = {}
    for folder in root.iter('SMART_FOLDER'):
        if (folderHasJaw(folder)):
            folder_dict[folder.attrib['FOLDER_NAME']] = folder
            print('folder {} added'.format(folder.attrib['FOLDER_NAME']))
    return folder_dict

def folderHasJaw(folder):
    for cond in folder.findall('INCOND'):
        if (cond.attrib['NAME'].startswith('JAW-')):
            return True
    return False

def del_folder_out_cond(folder_dict):
    for folder_name in folder_dict.keys():
        folder = folder_dict.get(folder_name)
        element_to_be_removed = True
        while element_to_be_removed:
            element_to_be_removed = False
            for element in folder:
                if (element.tag.find('OUTCOND') >= 0):
                    if (element.attrib['SIGN'].find('DEL') >= 0 or element.attrib['SIGN'].find('-') >= 0) and element.attrib['NAME'].startswith(folder_name + '_'):
                        folder.remove(element)
                        element_to_be_removed = True
    return
def handle_folder_pair(folder_mf,folder_ds):
    if (folder_ds == None):
        return
    folder_name = folder_mf.attrib['FOLDER_NAME']
    print('handling folder {} on both sides'.format(folder_name))
    for mf_incond in folder_mf.iter('INCOND'):
        orig_name = mf_incond.attrib['NAME']
        if (orig_name.startswith('JAW')):
            mf_new_name = orig_name.replace("JAW", "JAWMF", 1)
            ds_new_name = orig_name.replace("JAW", "JAWDS", 1)
            ds_incond = get_cond(folder_ds, orig_name, 'INCOND')
            mf_incond.attrib['NAME'] = mf_new_name
            ds_incond.attrib['NAME'] = mf_new_name
            added_mf_incond = ET.Element('INCOND')
            added_mf_incond.attrib['NAME'] = ds_new_name
            added_mf_incond.attrib['ODATE'] = mf_incond.attrib['ODATE']
            added_mf_incond.attrib['AND_OR'] = mf_incond.attrib['AND_OR']
            folder_mf.append(added_mf_incond)
            added_ds_incond = ET.Element('INCOND')
            added_ds_incond.attrib['NAME'] = ds_new_name
            added_ds_incond.attrib['ODATE'] = mf_incond.attrib['ODATE']
            added_ds_incond.attrib['AND_OR'] = mf_incond.attrib['AND_OR']
            folder_ds.append(added_mf_incond)



    # dict_of_all_ok_out_cond = get_dict_of_all_ok_out_cond(folder_mf)
    # dict_of_all_ok_out_cond.update(get_dict_of_all_ok_out_cond(folder_ds))
    # # if len(dict_of_all_ok_out_cond) > 0:
    # #     print ("folder {} has {} OK COND".format(folder_name, str(len(dict_of_all_ok_out_cond))))
    # not_in_use = 0
    # single_use = 0
    # multiple_use = 0
    # for cond_name in dict_of_all_ok_out_cond.keys():
    #     job_cond_as_out = dict_of_all_ok_out_cond.get(cond_name)
    #     list_of_all_jobs_that_have_it_as_in_cond = \
    #     get_list_of_all_jobs_that_have_it_as_in_cond(folder_mf, cond_name) + get_list_of_all_jobs_that_have_it_as_in_cond(folder_ds, cond_name)
    #     if len(list_of_all_jobs_that_have_it_as_in_cond) == 0:
    #         # print ("folder {} has {} OK COND that is not in use".format(folder_name, cond_name))
    #         delete_out_cond(job_cond_as_out, cond_name)
    #         not_in_use += 1
    #     elif len(list_of_all_jobs_that_have_it_as_in_cond) == 1:
    #         job_cond_as_in = list_of_all_jobs_that_have_it_as_in_cond[0]
    #         new_cond_name = get_new_cond_name(cond_name, job_cond_as_in, job_cond_as_out)
    #         rename_in_cond_and_del(job_cond_as_in, cond_name, new_cond_name)
    #         rename_out_cond(job_cond_as_out, cond_name, new_cond_name)
    #         single_use += 1
    #         # print ("folder {} has {} OK COND - single use".format(folder_name, cond_name))
    #     else:
    #         for job_cond_as_in in list_of_all_jobs_that_have_it_as_in_cond:
    #             new_cond_name = get_new_cond_name(cond_name, job_cond_as_in, job_cond_as_out)
    #             rename_in_cond_and_del(job_cond_as_in, cond_name, new_cond_name)
    #             add_out_cond_like_existing(job_cond_as_out, cond_name, new_cond_name)
    #         delete_out_cond(job_cond_as_out, cond_name)

    #         multiple_use += 1
    #         # print ("folder {} has {} OK COND - multiple uses".format(folder_name, cond_name))
    #         # print ("folder {} has {} OK COND".format(folder_name, str(len(dict_of_all_ok_out_cond))))
    # print ("Folder {}, has {} One Direction COND, {} not used and will be deleted, {} single use, {} multiple usage".format(\
    #     folder_name, str(len(dict_of_all_ok_out_cond)), str(not_in_use), str(single_use), str(multiple_use)))
    return

def get_cond(folder, name, inout):
    for cond in folder.iter(inout):
        if (cond.attrib['NAME'] == name):
            return cond

def get_new_cond_name(cond_name, job_cond_as_in, job_cond_as_out):
    target_folder_name = job_cond_as_out.attrib['GROUP']
    source_folder_name = job_cond_as_in.attrib['GROUP']
    try:
        target_job_name = job_cond_as_in.attrib['JOBNAME']
    except KeyError:
        target_job_name = job_cond_as_in.attrib['MEMNAME']
    if (condition_format == 'l'):
        new_cond_name = cond_name.replace(ok_suffix, "-" + target_folder_name + "_" + target_job_name)
    else:
        new_cond_name = cond_name.replace(ok_suffix, "-" + target_job_name + ok_suffix).replace(source_folder_name + "_", "", 1)
    return new_cond_name

def get_dict_of_all_ok_out_cond(folder):
    dict_of_out_cond:dict = {}
    if folder is not None:
        folder_name = folder.attrib['FOLDER_NAME']
        for job in folder.iter('JOB'):
            job_name = ''
            try:
                job_name = job.attrib['JOBNAME']
            except KeyError:
                job_name = job.attrib['MEMNAME']
            for out_cond in job.iter('OUTCOND'):
                out_cond_name:str = out_cond.attrib['NAME']
                if out_cond.attrib['SIGN'] == 'ADD' or out_cond.attrib['SIGN'] == '+':
                    # if re.match("\S*" + folder_name + '_' + job_name + "_\d\d" + ok_suffix,out_cond_name):
                    #     print ("condition with number component found: {}".format(out_cond_name))
                    if out_cond_name.endswith(folder_name + '_' + job_name + ok_suffix) or \
                        re.match("\S*" + folder_name + '_' + job_name + "_\d\d" + ok_suffix,out_cond_name) or \
                        re.match("\S*" + folder_name + '_' + job_name + "_S\d\d\d" + ok_suffix,out_cond_name):
                        dict_of_out_cond[out_cond_name] = job
                    else:
                        print('Condition {} in job {}/{} is not in scope'.format(out_cond_name, folder_name, job_name))
    return dict_of_out_cond

def get_list_of_all_jobs_that_have_it_as_in_cond(folder, cond_name):
    job_list = []
    if folder is not None:
        for job in folder.iter('JOB'):
            for in_cond in job.iter('INCOND'):
                if in_cond.attrib['NAME'] == cond_name:
                    job_list.append(job)
    return job_list

def rename_in_cond_and_del(job, cond_name, new_cond_name):
    for cond in job.iter('INCOND'):
        if cond.attrib['NAME'] == cond_name:
            cond.attrib['NAME'] = new_cond_name
    out_cond_to_insert = copy.deepcopy(cond)
    out_cond_to_insert.tag = 'OUTCOND'
    out_cond_to_insert.attrib['SIGN'] = '-'
    out_cond_to_insert.attrib['ODATE'] = remove_date
    out_cond_to_insert.attrib['NAME'] = new_cond_name
    del out_cond_to_insert.attrib['AND_OR']
    job.append(out_cond_to_insert)
    return
def rename_out_cond(job, cond_name, new_cond_name):
    for cond in job.iter('OUTCOND'):
        if cond.attrib['NAME'] == cond_name:
            cond.attrib['NAME'] = new_cond_name
    return
def add_out_cond_like_existing(job, cond_name, new_cond_name):
    for cond in job.iter('OUTCOND'):
        if cond.attrib['NAME'] == cond_name:
            out_cond_to_insert = copy.deepcopy(cond)
    out_cond_to_insert.attrib['NAME'] = new_cond_name
    job.append(out_cond_to_insert)
    return
def delete_out_cond(job, cond_name):
    for cond in job.iter('OUTCOND'):
        if cond.attrib['NAME'] == cond_name:
            job.remove(cond)
    return

start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")