#!/bin/sh
getPerlPathFromServerLocation()
{
	serverHome=`dirname "${CONTROLM_SERVER}"`
	serverPerl=$serverHome"/bmcperl/bin/perl"
	echo "$serverPerl"
}

#verbose is "Y" a log file will be created
verbose="N"

scriptLocation=$(dirname $0)
cd $scriptLocation
#the log directory can be edited here
logDir="./"
logFile=$logDir"scriptOutPut_$$.log"

#perl path can be edited here  
perlPath=""
if [ -z "$perlPath" ]; then
	perlPath=`getPerlPathFromServerLocation`
	if [ ! -x "$perlPath" ]; then   
		perlPath="perl";
	fi
fi
orderJobScript="orderJob.pl"
if [ ! -f $orderJobScript ]; then
    SCRIPTPATH=`pwd -P`
	args="$@"
	message="$SCRIPTPATH/$0 : cannot find $orderJobScript. command :\"$args\" will be ignored"
	ctmshout -DEST EM -MESSAGE "$message"
	exit
	fi

which $perlPath
isPerlExist=$?
	if [ $isPerlExist -eq 1 ]; then
	SCRIPTPATH=`pwd -P`
	args="$@"
	message="$SCRIPTPATH/$0: cannot find perl path:$perlPath. command :\"$args\" will be ignored"
	echo $message
	ctmshout -DEST EM -MESSAGE "$message"
   exit;
fi
output=`$perlPath $orderJobScript "$@"`
if [ "X$verbose" = "XY" ]; then 
	echo date > "$logFile"
	echo "perlPath $perlPath" >> "$logFile"
	echo "output $output" >> "$logFile"
fi

