#!/usr/bin/perl
# use strict;
# use warnings;
 
my $logFile;
my $VERBOSE = "N";
my  $command;
my  $nodeGroup;
my $isMultyAgent;
my $help;
my $man;
my $debug = 0 ;
my $logFileDir;
$VERBOSE = "N";
&getArgumentsFromCmd();

&verbose("check NODEGRP value : $nodeGroup")if(defined $nodeGroup);
my $isExistAgent = &isExistAgent($nodeGroup);
my $isExistHostGroup = &isExistHostGroup($nodeGroup);
if(!defined $nodeGroup || $nodeGroup eq "" || $isExistAgent ||  $isExistHostGroup)
{
	&sendCtmOrderCommand();
}
else
{
	my $errorMessage = "";
	$errorMessage =  "non valid ctmorder request:".$nodeGroup."is not exist as an host group or host.\ncommand \"$command\" will not execute"  ;
	&ctmshout($errorMessage);
	&printlog($errorMessage);
	}
	
sub getArgumentsFromCmd
{
	my $agentName = shift(@ARGV);
	$command = shift(@ARGV);
	my $urgancy = shift(@ARGV);
	
	if(!defined $command || $command !~ m/ctmorder.*$/)
	{
		my $usage = &getUsage(0);
		my $message;
		if (!defined $command ||  $command eq "")
		{
		  $message = "command is empty";
		}
		elsif($command !~ m/ctmorder\s*$/)
		{
		$message = "command \"".$command ."\" is not valid - only ctmorder command is valid";
		}		
		print $usage;
		&ctmshout($message);
		exit; 
	}
	if($command =~m/.*-variable\s+%%NODEGRP\s+(.*?)(?:\s+.*|$)/i)
	{
		$nodeGroup = $1; 
	}
	else
	{
		undef $nodeGroup; 
	}
	if($command =~m/(?:^|.*\s+)-debug(?:$|\s+.*)/)
	{
		$debug = 1;
		$command =~s/-debug//;
	}
	if(($command =~m/.*(?:^|.*\s+)-logdir\s+(.*?)\s*(?:$|\s+.*)/) && $debug)
	{
		$logFileDir = $1;
		my $logFileDirDoubleBackSlash = $logFileDir; 
		$logFileDirDoubleBackSlash=~s/\\/\\\\/g;
		$command =~s/-logdir\s+$logFileDirDoubleBackSlash//;
	}
	&openLogFile if($debug eq 1);
	verbose("get arguments...");
	verbose("agentName: $agentName");
	verbose("urgency: $urgancy");
	
	&verbose("nodeGroup: $nodeGroup") if defined $nodeGroup;
	&verbose("command: $command")if defined $command;
	&verbose("isMultyAgent: $isMultyAgent")if defined $isMultyAgent;
	&verbose("debug: yes")if defined $debug;
	&verbose("logFileDir: $logFileDir")if defined $logFileDir;
}

sub sendCtmOrderCommand
{
	$command = $command." 2>&1";
	$command = $command.";" if($^O ne "MSWin32");#if its not windows OS add ';' for the 2>&1
	printlog("run ordering command: ".$command);
	my $res = `$command`;
	$res =~ s/usage(.*\n.*)*//i;
	my $returnCode = $?;
	if($? ne 0)
	{
	
		my $errorMessage = "ctmorder command '".$command."' Faild:\n".$res;
		&ctmshout($errorMessage);
	}
	&printlogBeginNewSection(); 
	&printlog("output:\n $res");
	&printlogEndNewSection();
}

sub getUsage
{
	my @lines = <DATA>;
	return join("",@lines);
}

sub ctmshout
{
	
	my $errorMessage = shift();
	$errorMessage =~ s/"/\\"/g;
	my $scriptPath = __FILE__;
	$errorMessage = "Alerted from Shout Destination.\nProgram: ".$scriptPath."\nError: ".$errorMessage;
	if(length($errorMessage) > 256)
	{
		$errorMessage = substr( $errorMessage, 0, 255 );
	}
	$errorMessage = "\"".$errorMessage."\"";
	system("ctmshout -DEST EM -MESSAGE $errorMessage");
}


sub isExistAgent()
{
	my $agentName = shift();
	(&verbose("agent name not defined stop checking") and return 1) if(!defined $agentName or $agentName eq "");
	my $execCommand = "ctm_agstat -LIST *";
	verbose("check if agent \"$agentName\" exist...");
	verbose("run command : \"$execCommand\"...");
	my $ret = &isStringInCommandResult($agentName,$execCommand);
	my $isfound = "found";
	$isfound  = "not ".$isfound if (!$ret);
	&verbose("Host name \"$agentName\" $isfound");
	return $ret;
}

sub isExistHostGroup
{
	my $groupName = shift();
	&verbose("checking if node group \"$groupName\"exist....");
	&verbose("node group not defined stop checking") &&return 1 if(!defined $groupName);
	my $execCommand = "ctmhostgrp -list";
	verbose("run command : \"$execCommand\"...");
	my $isExist = isStringInCommandResult($groupName,$execCommand); 
	my $isfound = "found";
	$isfound  = "not ".$isfound if (!$isExist);
	&verbose("host group \"$nodeGroup\" $isfound"); 
	return $isExist ;
}

sub isStringInCommandResult
{ 	
	my $string = shift();
	my $command = shift();
	my $res = `$command`;
	my @lines = split /^/m, $res;
	&verbose("lines");
	&verbose("@lines");
	my @linesWithGroupName = grep(/(^|.*\s+)$string\s+/i, @lines);
	&verbose("lines with group name:");
	&verbose("@linesWithGroupName");
	my $isExist = @linesWithGroupName != 0; 
	&verbose("Result: true ") if($isExist);
	return $isExist ;
}

sub openLogFile
{ 	
	$logFileDir = "" if !defined $logFileDir;
	$logFileDir = $logFileDir."\\" if $logFileDir ne "";
	my $logFilePath = $logFileDir."order".$$.".log";
	
	verbose("open log file $logFilePath...");
	open $logFile,">>".$logFilePath;
}

sub verbose
{
	my $string = shift(); 
	&printlog($string);
}

sub printlog
{
	my $string = shift();
	my $timestamp = localtime(time);
	print $string."\n" if(defined $VERBOSE && $VERBOSE eq "Y");
	# verbose($string);
	print $logFile $timestamp .": ". $string."\n" if(defined $logFile);
}

sub printlogBeginNewSection
{
	my $starsLine =  "***********************************\n";
	print $logFile $starsLine if(defined $logFile); 
}

sub printlogEndNewSection
{
	my $starsLine =  "***********************************\n";
	print $logFile $starsLine if(defined $logFile);
}

 __DATA__

USAGE

orderJob.pl <agentName> <ctmorder Command> <Urgancy> 			

DESCRIPTION

this program will should be called via a Contorol-M Messge mechanism.
it take 3 arguments <agentName> <ctmorder Command> <Urgancy>.
this script is refers only for the second parameter

If the ctmorder contain an overriden of the NODEGRP variable (through the expression -VARABLE %%NODEGRP <NAME>) 
the script will check first if the specified name is exist as an Agent or a Host Group in the em server through the "ctm_agstat" and "ctmhostgrp" commands respectively.
only if the specified name exist it will call the "ctmorder" command.   
   
OPTIONS:
the ctmorder Command could contain a spaciel options for this script 
	-debug	: if specify will write all logs to a file named  order.log.
	-logdir	<DIR PATH>: if specify with the -debug option  will put the order.log in the <DIR PATH> loaction.
	