JSONP.response({
  responseText: '﻿<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\
<title> Defining a new IBM Tivoli Workload Scheduler conversion project </title>\
<script type=\"text/javascript\">\
        function isTOCLoaded() {\
            /* this function for loading the topic within the application if loaded by itself */\
            /* i.e. open the topic .htm file or as search engines link */\
            var url = window.location.href;\
            var baseUrl = url.substring(0, url.lastIndexOf(\"/\") + 1);\
            var topicFile = url.substring(url.lastIndexOf(\"/\") + 1);\
            var newUrl = baseUrl + \"index.htm#\" + topicFile;\
            location.href = newUrl;\
            return false;\
        }\
</script>\
<script language=\"javascript\" type=\"text/javascript\" src=\"dhtml_popup.js\"></script>\
</head>\
<body  onload=\"if (isTOCLoaded()) {expand(\'99699\');highlight(\'45998\')}\">\
<h2 id=\"t45998\" class=\"heading2\">Defining a new IBM Tivoli Workload Scheduler conversion project</h2>\
<p class=\"bodytext\">This topic describes how to define a new IBM Tivoli Workload Scheduler (TWS) conversion project. You can also analyze the complexity of the conversion project by viewing the assessment report.</p>\
<p class=\"bodytext\">For more information about creating a new conversion project, see <a id=\"h5911\" class=\"jumptemplate\" title=\"Creating a new Conversion Tool project\" href=\"Run_new_conv_project.htm\" target=\"_self\">Creating a new Conversion Tool project</a>.</p>\
<p class=\"beforeyoubegin\">Before you begin</p>\
<p class=\"bodytext\">Ensure the following:</p>\
<ul class=\"listbullet\"><li class=\"listbullet\">Create and export Definition files in the Tivoli environment, as described in <a id=\"h46064\" class=\"jumptemplate\" title=\"Extracting IBM Tivoli Workload Scheduler data\" href=\"46063.htm\" target=\"_self\">Extracting IBM Tivoli Workload Scheduler data</a>.</li><li class=\"listbullet\">Define a new project, as described in <a id=\"h5911_2\" class=\"jumptemplate\" title=\"Creating a new Conversion Tool project\" href=\"Run_new_conv_project.htm\" target=\"_self\">Creating a new Conversion Tool project</a>.</li></ul><p class=\"procedureheading\">To define a new TWS conversion project:</p>\
<ol class=\"listnumber\"><li class=\"listnumber\">From the <strong class=\"strong\">IBM Tivoli Workload Scheduler - Load Data</strong> window, in the <strong class=\"strong\">Import Scheduling Data</strong> area, click  to locate and select the <a id=\"h46065\" class=\"expandingblocktemplate\" title=\"TWS scheduling data parameters\" href=\"javascript:toggleBlock(\'46065\')\" target=\"_self\">Import Scheduling Data parameters for TWS</a>.<div id=\"d46065\" class=\"expandingblock\" style=\"display:none\"><p class=\"bodytext\">The following table describes the TWS scheduling data parameters.</p>\
<table class=\"tableintopic\" width=\"606\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"border-collapse:collapse; border:1px solid #010101\">\
<tr align=\"left\" valign=\"top\">\
<th bgcolor=\"#DBE5F1\" style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tableheading\">Parameter</p>\
</th>\
<th bgcolor=\"#DBE5F1\" style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tableheading\">Description</p>\
</th>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Job definitions</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Contains all the job attributes that relate to the job\'s functioning and/or how each job should be submitted. For example, which agent to submit the job to, which script to run, the owner of the job (the user who has the credentials for the job\'s functions), and the job description.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">CPU definitions</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Contains the physical host name for each logical CPU mentioned in schedule.txt, see below. The Control-M Conversion Tool uses this value for the Host ID field in the Control-M job definition.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Parameter definitions</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Contains the actual value for each parameter mentioned in the jobs.txt file. The Control-M Conversion Tool defines each parameter mentioned in the jobs.txt file as a Variable expression.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Schedule definitions</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines the main file to be imported, which includes the scheduling criteria of each job, and the dependencies between the jobs. Each job in the jobs.txt file can be scheduled more than once.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Resource definitions file</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the resources which is required by tables and jobs and used by the Conversion Tool.  </p>\
<p class=\"tablebodytext\">TWS command: composer create &lt;resource file&gt; from RESOURCES.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Calendar definitions file</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Translates the information in this file from the Conversion Tool into Control-M calendars.</p>\
<p class=\"tablebodytext\">TWS command: composer create &lt;calendars file&gt; from CALENDARS.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Variable tables definitions file</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the variables which are used by the Conversion Tool. </p>\
<p class=\"tablebodytext\">TWS command: composer create &lt;variables file&gt; from VARIABLES.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Workstation parameters directory</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the workstation variables. The file names in this folder should be in the following format: &lt;CPU_name&gt;_parms.txt (for example: Workstation1_parms.txt). This should convert  Workstation specific variables during the conversion. </p>\
<p class=\"tablebodytext\">TWS format: &lt;CPU_name&gt;_parms.txt</p>\
</td>\
</tr>\
\
</table>\
<p class=\"bodytext\"></p>\
</div></li><li class=\"listnumber\">Click <strong class=\"strong\">Import</strong>.<p class=\"listcontinue\">The data is loaded into the Conversion Tool and in the <strong class=\"strong\">Assessment Report</strong> window a summary of the imported data appears. For more information, see <a id=\"h46362\" class=\"jumptemplate\" title=\"Data evaluation\" href=\"46358.htm\" target=\"_self\">Data evaluation</a>.</p>\
</li><li class=\"listnumber\">Click <strong class=\"strong\">Next</strong>.<p class=\"listcontinue\">The <strong class=\"strong\">Run Conversion </strong>window appears.</p>\
</li><li class=\"listnumber\">Select <strong class=\"strong\">Run conversion</strong> or<strong class=\"strong\"> Load existing conversion results</strong>. <p class=\"listcontinue\">For more information about conversion, see <a id=\"h21540\" class=\"jumptemplate\" title=\"Data conversion\" href=\"Conv_project_results.htm\" target=\"_self\">Data conversion</a>.</p>\
</li><li class=\"listnumber\">Click <strong class=\"strong\">Next</strong>.<p class=\"listcontinue\">The <strong class=\"strong\">Conversion Settings</strong> window appears.</p>\
</li><li class=\"listnumber\">Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in <a id=\"h5898\" class=\"jumptemplate\" title=\"Conversion settings\" href=\"Conv_rules_step.htm\" target=\"_self\">Conversion settings</a>. <p class=\"listnote\"><strong class=\"notebold\">NOTE:</strong> (Optional) In the Validation phase, you can compare your scheduler\'s forecast report to the Control-M forecast report created during validation. To create the report, use any of the report parameter files below.</p>\
<ul class=\"listnotebullet\"><li class=\"listnotebullet\">If you want a report for three months from specific workstations, use: rep11 -m mmyyyy mmyyyy mmyyyy -c workstation1 workstation2 workstation3. For example, rep11 -m 062004 072004 082004 -c workstation1 workstation2 workstation3.</li><li class=\"listnotebullet\">If you want a report for three months of the current year from all workstations, which directly outputs to a file, use: rep11 -m mm mm mm -o output. For example, rep11 -m 06 07 08 -o output.</li><li class=\"listnotebullet\">If you want a report for the current month for a specific workstation, use: rep11 -c workstation1.</li></ul><p class=\"listnotecontinue\">For more information, see <a id=\"h5901\" class=\"jumptemplate\" title=\"Data validation\" href=\"Validation_step.htm\" target=\"_self\">Data validation</a>.</p>\
</li></ol><table class=\"relatedtopics belowtopictext\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\
<tr valign=\"top\">\
<td>\
<h3 class=\"relatedheading\">Parent Topic</h3><p class=\"relateditem\"><a href=\"99699.htm\" target=\"_self\">IBM Tivoli Workload Scheduler</a></p></td>\
</tr>\
</table>\
\
\
<script>\
  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\
  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\
\
  ga(\'create\', \'UA-87414765-1\', \'auto\');\
  ga(\'send\', \'pageview\');\
</script>\
<input id=\"topicId\" type=\"hidden\" value=\"45998\" />\
<input id=\"topicDescription\" type=\"hidden\" value=\"Defining a new IBM Tivoli Workload Scheduler conversion project\" />\
<input id=\"footer-modified\" type=\"hidden\" value=\"Page last modified on: 8/7/2017 12:54:00 PM\" />\
</body>\
</html>\
'
});