/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.session;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPFactory;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSessionTree;
import java.util.Set;

public class SessionEntry {
    private String nodeName;
    private String returnCode;
    private DollarUniverseSessionTree session;
    private Integer fatherNumber;
    private Integer sonNumber;
    private String fatherNumberAsString;
    private String sonNumberNumberAsString;
    private String fatherUprocName;
    private String sonUprocName;
    private Path path;
    private HDPRelationship hdpmu;

    public SessionEntry(IAttrHolder entryHolder, DollarUniverseSessionTree session) {
        if (entryHolder == null) {
            return;
        }
        this.session = session;
        this.fatherNumber = entryHolder.getAttrAsInt("NumF");
        this.sonNumber = entryHolder.getAttrAsInt("NumS");
        this.fatherNumberAsString = entryHolder.getAttr("NumF");
        this.sonNumberNumberAsString = entryHolder.getAttr("NumS");
        this.fatherUprocName = entryHolder.getAttr("Father");
        this.sonUprocName = entryHolder.getAttr("Son");
        this.path = this.getPath(entryHolder);
        this.nodeName = entryHolder.getAttr("node name");
        String hdpExpr = entryHolder.getAttr("HDP/MU");
        this.hdpmu = new HDPFactory().makeRelationShip(hdpExpr, this.nodeName);
        this.returnCode = entryHolder.getAttr("Return Code");
    }

    public boolean returnCodeIsAsterisk() {
        return "*".equals(this.returnCode);
    }

    private Path getPath(IAttrHolder entryHolder) {
        if (entryHolder.getAttr("Path").equals("OK")) {
            return Path.OK;
        }
        return Path.NOTOK;
    }

    public Integer getFatherNumber() {
        return this.fatherNumber;
    }

    public Integer getSonNumber() {
        return this.sonNumber;
    }

    public String getFatherUprocName() {
        return this.fatherUprocName;
    }

    public String getSonUprocName() {
        return this.sonUprocName;
    }

    public String getPath() {
        return this.path.value;
    }

    public HDPRelationship getHDPMU() {
        return this.hdpmu;
    }

    public boolean isValid() {
        return this.sonNumber != null && this.fatherNumber != null;
    }

    public boolean isUsingHdp() {
        return this.hdpmu.isHdp();
    }

    public boolean isPathOK() {
        return this.path.equals(Path.OK);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fatherNumber == null ? 0 : this.fatherNumber.hashCode());
        result = 31 * result + (this.fatherNumberAsString == null ? 0 : this.fatherNumberAsString.hashCode());
        result = 31 * result + (this.fatherUprocName == null ? 0 : this.fatherUprocName.hashCode());
        result = 31 * result + (this.hdpmu == null ? 0 : this.hdpmu.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.sonNumber == null ? 0 : this.sonNumber.hashCode());
        result = 31 * result + (this.sonNumberNumberAsString == null ? 0 : this.sonNumberNumberAsString.hashCode());
        result = 31 * result + (this.sonUprocName == null ? 0 : this.sonUprocName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionEntry other = (SessionEntry)obj;
        if (this.fatherNumber == null ? other.fatherNumber != null : !this.fatherNumber.equals(other.fatherNumber)) {
            return false;
        }
        if (this.fatherNumberAsString == null ? other.fatherNumberAsString != null : !this.fatherNumberAsString.equals(other.fatherNumberAsString)) {
            return false;
        }
        if (this.fatherUprocName == null ? other.fatherUprocName != null : !this.fatherUprocName.equals(other.fatherUprocName)) {
            return false;
        }
        if (this.hdpmu == null ? other.hdpmu != null : !this.hdpmu.equals(other.hdpmu)) {
            return false;
        }
        if (this.path != other.path) {
            return false;
        }
        if (this.sonNumber == null ? other.sonNumber != null : !this.sonNumber.equals(other.sonNumber)) {
            return false;
        }
        if (this.sonNumberNumberAsString == null ? other.sonNumberNumberAsString != null : !this.sonNumberNumberAsString.equals(other.sonNumberNumberAsString)) {
            return false;
        }
        return !(this.sonUprocName == null ? other.sonUprocName != null : !this.sonUprocName.equals(other.sonUprocName));
    }

    public String toString() {
        return "SessionEntry [fatherNumber=" + this.fatherNumber + ", sonNumber=" + this.sonNumber + ", fatherUprocName=" + this.fatherUprocName + ", sonUprocName=" + this.sonUprocName + ", path=" + String.valueOf((Object)this.path) + ", hdpmu=" + String.valueOf(this.hdpmu) + "]";
    }

    public boolean isFatherAHeader() {
        return this.fatherNumber.equals(1);
    }

    public boolean isFatherInHdpContext() {
        Integer fatherNumber = this.getFatherNumber();
        boolean isFatherInHdpContext = this.session.isUprocInHdpContext(fatherNumber);
        return isFatherInHdpContext;
    }

    public Set<String> getFatherMus() {
        Set<String> mus = this.session.getUprocMus(this.fatherNumber);
        return mus;
    }

    public static enum Path {
        OK("OK"),
        NOTOK("NOTOK");

        private String value;

        private Path(String value) {
            this.value = value;
        }

        public boolean equals(Path path) {
            if (path == null) {
                return false;
            }
            return this.value.equals(path.value);
        }

        public boolean equals(String path) {
            return this.value.equals(path);
        }
    }
}

