/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.session;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateConditionByNewFormat;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSessionTree;
import com.bmc.ctmconvert.dollar_universe.session.MuResolver;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DollarUniverseSession
extends DollarUniverseSessionTree {
    private String headerMu;
    MuResolver resolver = null;

    public DollarUniverseSession(DollarUniverseSessionAttributes taskSession, String headerMu, MuHierarchy muHierarchy) {
        super(taskSession);
        this.headerMu = headerMu;
        this.resolver = new MuResolver(muHierarchy, this);
    }

    @Override
    public Set<String> getUprocMus(Integer fatherNumber) {
        HashSet<String> ret = this.resolver.getUprocMus(fatherNumber);
        return ret;
    }

    public String getHeaderMu() {
        return this.headerMu;
    }

    private DollarUniverseSessionTree.SessionElement getSessionElemntByNumber(Integer uprocNumber) {
        Optional<DollarUniverseSessionTree.SessionElement> optioalUproc = this.getSessionTree().toList().stream().filter(this.isSessionElementHasNumber(uprocNumber)).findFirst();
        return optioalUproc.get();
    }

    private boolean isContainUprocNumber(Integer uprocNumber) {
        Optional<DollarUniverseSessionTree.SessionElement> optioalUproc = this.getSessionTree().toList().stream().filter(this.isSessionElementHasNumber(uprocNumber)).findFirst();
        return optioalUproc.isPresent();
    }

    public boolean isEntryInHdpContext(SessionEntry entry) {
        if (entry == null || !entry.isValid() || !this.getSessionEntryList().contains(entry)) {
            return false;
        }
        Integer sonNumber = entry.getSonNumber();
        return this.isUprocInHdpContext(sonNumber);
    }

    public List<SessionEntry> getSessionAttributeListFromFirstHdpUse() {
        int firstUseOfHdpIndex = this.getSessionEntryList().size();
        for (SessionEntry entry : this.getSessionEntryList()) {
            if (!entry.isUsingHdp()) continue;
            firstUseOfHdpIndex = this.getSessionEntryList().indexOf(entry);
            break;
        }
        return this.getSessionEntryList().subList(firstUseOfHdpIndex, this.getSessionEntryList().size());
    }

    public boolean isSessionUsingHDP() {
        for (SessionEntry sessionEntry : this.getSessionEntryList()) {
            if (!sessionEntry.isUsingHdp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUprocInHdpContext(Integer uprocNumber) {
        if (!this.isContainUprocNumber(uprocNumber)) {
            return false;
        }
        DollarUniverseSessionTree.SessionElement sessionElement = this.getSessionElemntByNumber(uprocNumber);
        List<DollarUniverseSessionTree.SessionElement> pathToRoot = this.getSessionTree().getPathFromRoot(sessionElement);
        for (DollarUniverseSessionTree.SessionElement pathUproc : pathToRoot) {
            if (!pathUproc.getHdpRelationship().isHdp().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAsteriskReturnCode(String conditionName, String folderNameOfThisJob) {
        return this.getSessionEntryList().stream().anyMatch(sessionEntry -> DollarUniverseSession.doesConditionStartFromFather(conditionName, sessionEntry.getFatherUprocName(), folderNameOfThisJob) && sessionEntry.returnCodeIsAsterisk());
    }

    private static boolean doesConditionStartFromFather(String conditionName, String fatherUprocName, String folderNameOfThisJob) {
        String[] parts = conditionName.split("-TO-");
        if (parts.length > 1) {
            String searchFor = fatherUprocName;
            if (folderNameOfThisJob != null && !folderNameOfThisJob.isEmpty()) {
                searchFor = DollarUniverseCreateConditionByNewFormat.buildAtoBPart(fatherUprocName, folderNameOfThisJob);
            }
            return conditionName.split("-TO-")[0].startsWith(searchFor);
        }
        return conditionName.startsWith(fatherUprocName);
    }
}

