/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuleLaunchTime
implements LaunchWindow {
    private final DollarUniverseTaskAttributes sourceTaskDefinition;

    public RuleLaunchTime(DollarUniverseTaskAttributes sourceTaskDefinition) {
        this.sourceTaskDefinition = sourceTaskDefinition;
    }

    public static List<String> getLaunchTimesFromTaskRule(DollarUniverseTaskAttributes sourceTaskDefinition) {
        String rule = sourceTaskDefinition.getAttributes().getAttr("rule");
        if (rule != null) {
            String launchTime = Stream.of(rule.split("\n")).filter(s -> s.startsWith("launch time:")).findFirst().orElse("");
            Pattern timePatternWithColonSeparator = Pattern.compile("\\d{2}:\\d{2}");
            Matcher timeResults = timePatternWithColonSeparator.matcher(launchTime);
            return timeResults.results().map(MatchResult::group).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Optional<LaunchWindow> getLaunchWindow() {
        return Optional.of(this);
    }

    @Override
    public HashMap<String, String> getAttributes() {
        List<String> results = RuleLaunchTime.getLaunchTimesFromTaskRule(this.sourceTaskDefinition);
        return switch (results.size()) {
            case 0 -> new HashMap();
            case 1 -> this.getAttributesForFromTime(results);
            default -> this.getAttributesForCyclicWithSpecificTimes(results);
        };
    }

    private HashMap<String, String> getAttributesForFromTime(List<String> results) {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("TIMEFROM", results.get(0).replace(":", ""));
        return stringStringHashMap;
    }

    private HashMap<String, String> getAttributesForCyclicWithSpecificTimes(List<String> results) {
        String sequence = results.stream().map(r -> r.replace(":", "")).collect(Collectors.joining(","));
        return new HashMap<String, String>(GlobalFunctions.attributesCyclicStartSequence((String)sequence));
    }

    @Override
    public void convertLaunchWindow() {
    }
}

