/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.EndTimeFormat;
import com.bmc.ctmconvert.dollar_universe.TimeToCalculator;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchATWindowParser;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchWindowTimeMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MultiLaunchWindowATConvertor
implements LaunchWindow {
    private HashMap<String, String> windowAtributes;
    private final Optional<String> elapse;
    private final DollarUniverseJob job;
    private final String mulw;

    public MultiLaunchWindowATConvertor(DollarUniverseJob job, String mulw, Optional<String> elapse) {
        this.elapse = elapse;
        this.job = job;
        this.mulw = mulw;
    }

    @Override
    public void convertLaunchWindow() {
        this.windowAtributes = new HashMap();
        if (this.isASingleWindow(this.mulw, this.elapse)) {
            this.initSingleWindow(this.mulw);
        } else {
            this.initSeveralWindows(this.mulw);
        }
    }

    private void initSingleWindow(String mulw) {
        List<String> windows = MultiLaunchWindowATConvertor.getTimes(mulw, this.elapse);
        MultiLaunchATWindowParser parser = new MultiLaunchATWindowParser(windows.get(0), this.elapse);
        String timeAsString = parser.getMulwTimeAsString();
        if (timeAsString.isEmpty()) {
            return;
        }
        this.windowAtributes.put("TIMEFROM", timeAsString);
        TimeToCalculator.Time windowtime = parser.getWindowTime();
        if (windowtime == null) {
            return;
        }
        TimeToCalculator.Time endTime = parser.getMulwTime().add(windowtime);
        this.windowAtributes.put("TIMETO", EndTimeFormat.format(endTime.getHourInDay(), endTime.getMinutesInDAy()));
    }

    private void initSeveralWindows(String mulw) {
        MultiLaunchWindowTimeMatcher timeMatcher = new MultiLaunchWindowTimeMatcher(this.elapse);
        List<MultiLaunchATWindowParser> times = timeMatcher.getTimesOfATWindowOption(mulw).stream().map(window -> new MultiLaunchATWindowParser((String)window, this.elapse)).collect(Collectors.toList());
        if (times.isEmpty()) {
            this.job.addReporterMessage("WRN7033", this.job.getOriginalJobName(), mulw.replaceAll("\n", " "), this.job.getJobName());
        } else {
            this.windowAtributes.putAll(GlobalFunctions.attributesCyclicSpecificSequence((String)this.convertMultiWindow(times).toString()));
        }
    }

    private StringBuilder convertMultiWindow(List<MultiLaunchATWindowParser> times) {
        StringBuilder timeSequenceBuilder = new StringBuilder();
        for (MultiLaunchATWindowParser multiWindow : times) {
            String time = multiWindow.getMulwTimeAsString();
            if (timeSequenceBuilder.indexOf(time) < 0) {
                timeSequenceBuilder.append(time + ",");
            }
            if (this.windowAtributes.containsKey("CYCLIC_TOLERANCE")) continue;
            int MAX_TOLARANCE = 999;
            Integer tolaranceAsInt = multiWindow.getTolarance();
            if (tolaranceAsInt != null && tolaranceAsInt > MAX_TOLARANCE) {
                this.job.addReporterMessage("WRN7030", this.job.getOriginalJobName(), tolaranceAsInt.toString());
                tolaranceAsInt = MAX_TOLARANCE;
            }
            String tolarance = tolaranceAsInt != null ? tolaranceAsInt.toString() : "";
            this.windowAtributes.put("CYCLIC_TOLERANCE", tolarance);
        }
        if (timeSequenceBuilder.length() > 0) {
            timeSequenceBuilder.deleteCharAt(timeSequenceBuilder.length() - 1);
        }
        return timeSequenceBuilder;
    }

    private boolean isASingleWindow(String mulw, Optional<String> elapse) {
        List<String> windows = MultiLaunchWindowATConvertor.getTimes(mulw, elapse);
        boolean isSingle = windows.size() == 1;
        return isSingle;
    }

    private static List<String> getTimes(String mulw, Optional<String> elapse) {
        MultiLaunchWindowTimeMatcher timeMatcher = new MultiLaunchWindowTimeMatcher(elapse);
        List<String> windows = timeMatcher.getTimesOfATWindowOption(mulw);
        return windows;
    }

    @Override
    public HashMap<String, String> getAttributes() {
        return this.windowAtributes;
    }
}

