/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.dollar_universe.EndTimeFormat;
import com.bmc.ctmconvert.dollar_universe.TimeToCalculator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiLaunchFROMWindowParser {
    private static final Pattern timePattern = Pattern.compile("(?<TIMEFROM>[0-9]{4}),(?<TIMEUNTIL>[0-9]{4}),(?<EVERY>[0-9]{3})");
    private static final Pattern durationPattern = Pattern.compile(",(?<DURATIONHOURS>[0-9]{3}),(?<DURATIONMIN>[0-9]{2})");
    private final Matcher timeMatcher;
    private final Matcher durationMatcher;

    public MultiLaunchFROMWindowParser(String mulw) {
        this.timeMatcher = timePattern.matcher(mulw);
        this.timeMatcher.find();
        this.durationMatcher = durationPattern.matcher(mulw);
        this.durationMatcher.find();
    }

    public String getTime(String group) {
        try {
            return this.timeMatcher.group(group);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Integer getDurationHours() {
        return Integer.parseInt(this.durationMatcher.group("DURATIONHOURS"));
    }

    private Integer getDurationMin() {
        return Integer.parseInt(this.durationMatcher.group("DURATIONMIN"));
    }

    public String getFromTime() {
        return this.getTime("TIMEFROM");
    }

    public String getUntilTime() {
        return this.getTime("TIMEUNTIL");
    }

    public String getEveryTime() {
        return this.getTime("EVERY");
    }

    public TimeToCalculator.Time getDurationTime() {
        try {
            return new TimeToCalculator.Time(this.getDurationHours(), this.getDurationMin());
        }
        catch (NumberFormatException e) {
            return new TimeToCalculator.Time(0, 0);
        }
    }

    public int getDurationTotalMinutes() {
        try {
            return this.getDurationHours() * 60 + this.getDurationMin();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String generateTimeIntervals(StringBuilder timeSequenceBuilder) {
        int intervalMinutes = Integer.parseInt(this.getEveryTime());
        if (intervalMinutes <= 0) {
            return "";
        }
        int endMinutes = this.totalMinutesFromString(this.getUntilTime());
        StringBuilder timeIntervals = new StringBuilder();
        for (int currentMinutes = this.totalMinutesFromString(this.getFromTime()); currentMinutes <= endMinutes; currentMinutes += intervalMinutes) {
            String formattedTime = EndTimeFormat.format(currentMinutes / 60, currentMinutes % 60);
            if (timeSequenceBuilder.indexOf(formattedTime) >= 0) continue;
            if (!timeIntervals.isEmpty()) {
                timeIntervals.append(",");
            }
            timeIntervals.append(formattedTime);
        }
        return timeIntervals.isEmpty() ? "" : timeIntervals.toString();
    }

    private int totalMinutesFromString(String timeString) {
        int hour = Integer.parseInt(timeString.substring(0, 2));
        int min = Integer.parseInt(timeString.substring(2));
        return hour * 60 + min;
    }
}

