/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.common.message.MessageIssuer;
import java.util.HashMap;

public class LaunchWindowCrossesNewdayCalculator {
    public static final int HOURS_IN_A_DAY = 2400;
    public static final String NORMALIZED_NEWDAY = "0000";
    private HashMap<String, String> launchWindowAttributes;
    private MessageIssuer messageIssuer;
    private String normalizedTimeFrom;
    private String normalizedTimeTo;
    private int newDayTime;

    public LaunchWindowCrossesNewdayCalculator(HashMap<String, String> launchWindowAttributes, MessageIssuer messageIssuer, String newDayTime) {
        this.newDayTime = newDayTime == null || newDayTime.isEmpty() ? 0 : Integer.parseInt(newDayTime);
        this.launchWindowAttributes = launchWindowAttributes == null ? new HashMap() : new HashMap<String, String>(launchWindowAttributes);
        this.normalizedTimeFrom = this.normalizeTime(this.launchWindowAttributes.get("TIMEFROM"));
        this.normalizedTimeTo = this.normalizeTime(this.launchWindowAttributes.get("TIMETO"));
        this.messageIssuer = messageIssuer;
    }

    private String normalizeTime(String time) {
        if (time == null || time.isEmpty()) {
            return time;
        }
        int theTime = Integer.parseInt(time);
        int normalizedTime = (theTime + (2400 - this.newDayTime)) % 2400;
        return String.format("%04d", normalizedTime);
    }

    public HashMap<String, String> handleTimeWindowThatCrossesNewday() {
        if (this.missingTimeFromOrTimeTo()) {
            return this.launchWindowAttributes;
        }
        String newTimeTo = this.calculateFinalTimeTo();
        if (">".equals(newTimeTo)) {
            this.handleAllowSubmissinPastNextNewDay(newTimeTo);
        }
        return this.launchWindowAttributes;
    }

    private void handleAllowSubmissinPastNextNewDay(String newTimeTo) {
        String cyclic = this.launchWindowAttributes.get("CYCLIC");
        if (!"1".equals(cyclic)) {
            this.launchWindowAttributes.put("TIMETO", newTimeTo);
        }
        this.messageIssuer.issueMessage();
    }

    private String calculateFinalTimeTo() {
        return this.isTimeWindowCrossesNewDay() ? ">" : this.normalizedTimeTo;
    }

    private boolean isTimeWindowCrossesNewDay() {
        return this.toTimeIsDifferentThanNewday() && this.toTimeIsSmallerThanFromTime();
    }

    private boolean toTimeIsSmallerThanFromTime() {
        return this.normalizedTimeTo.compareTo(this.normalizedTimeFrom) < 0;
    }

    private boolean toTimeIsDifferentThanNewday() {
        return !this.normalizedTimeTo.equals(NORMALIZED_NEWDAY);
    }

    private boolean missingTimeFromOrTimeTo() {
        return this.normalizedTimeFrom == null || this.normalizedTimeTo == null;
    }
}

