/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.EndTimeFormat;
import com.bmc.ctmconvert.dollar_universe.OldTimePattern;
import com.bmc.ctmconvert.dollar_universe.TimeToCalculator;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import java.util.HashMap;
import java.util.Map;

public class DailyLaunchWindow
implements LaunchWindow {
    HashMap<String, String> attributes = new HashMap();
    DollarUniverseJob job;
    private Map<String, String> allDays;

    public DailyLaunchWindow(DollarUniverseJob job, Map<String, String> allDays) {
        this.job = job;
        this.allDays = allDays;
    }

    @Override
    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    private void convertLaunchWindow(String dalw) {
        if (dalw == null || dalw.isEmpty()) {
            return;
        }
        if (dalw.matches("^[ \t]*\\(0{4}+,0{3}+,0{2}+\\)")) {
            Reporter.addMessage(this.job.getMessages(), (String)"WRN7019", (String)this.job.getOriginalJobId(), (String[])new String[]{dalw, this.job.getTaskAttribute("upr")});
            return;
        }
        String[] arr = (dalw = dalw.replaceAll("^[ \t]*\\(", "").replaceAll("\\).*", "")).split(",");
        if (arr.length != 3) {
            Reporter.addMessage(this.job.getMessages(), (String)"WRN7018", (String)this.job.getOriginalJobId(), (String[])new String[]{dalw, this.job.getTaskAttribute("upr")});
            return;
        }
        this.attributes.put("TIMEFROM", arr[0]);
        try {
            OldTimePattern oldTimePattern = OldTimePattern.from(dalw);
            Integer startHour = oldTimePattern.getStartHour();
            Integer startMinutes = oldTimePattern.getStartMinutes();
            Integer windowHour = oldTimePattern.getWindowHour();
            Integer windowMinutes = oldTimePattern.getWindowMinutes();
            TimeToCalculator.Time time = TimeToCalculator.calculate(startHour, startMinutes, windowHour, windowMinutes);
            this.attributes.put("TIMETO", EndTimeFormat.format(time.getHourInDay(), time.getMinutesInDAy()));
        }
        catch (OldTimePattern.NotValidTimePatternException e) {
            Reporter.addMessage(this.job.getMessages(), (String)"WRN7018", (String)this.job.getOriginalJobId(), (String[])new String[]{dalw, this.job.getTaskAttribute("upr")});
        }
    }

    @Override
    public void convertLaunchWindow() {
        String dalw = this.allDays.get("dalw");
        for (String dayFromValue : this.allDays.values()) {
            if (dayFromValue.equals(dalw)) continue;
            Reporter.addMessage(this.job.getMessages(), (String)"WRN7038", (String)this.job.getOriginalJobId(), (String[])new String[]{this.job.getOriginalJobName(), this.job.getJobName(), dalw});
            break;
        }
        this.convertLaunchWindow(dalw);
    }
}

