/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;

public class ReferenceJobHandler {
    private IAttrHolder sessionUprAttributes;
    private DollarUniverseJob parent;
    private DollarUniverseDefs defs;
    public static String ReferencePath_Prefix = "EXP_TemplateJobs_/";

    public ReferenceJobHandler(IAttrHolder sessionUprAttributes, DollarUniverseJob parent, DollarUniverseDefs defs) {
        this.sessionUprAttributes = sessionUprAttributes;
        this.parent = parent;
        this.defs = defs;
    }

    public String getUprIdBySessionUprAttributes() {
        return this.sessionUprAttributes.getAttr(this.parent.getUprFieldName()) + "_" + this.sessionUprAttributes.getAttr("node name");
    }

    public boolean isTemplateJob() {
        return this.defs.isConvertTemplatesRuleEnabled() && this.defs.getTemplateUprsByNode(this.parent.getNodeName()).contains(this.getUprIdBySessionUprAttributes()) && !this.isReferencedJob();
    }

    private boolean isReferencedJob() {
        if (this.isDataWithoutNodes()) {
            return this.parent.getType().equals((Object)SchedEntity.TYPE.SMART_TABLE) && this.parent.getJobName().contains("TemplateJobs");
        }
        return this.parent.getType().equals((Object)SchedEntity.TYPE.SUB_TABLE) && this.parent.getParentName().contains("TemplateJobs");
    }

    private boolean isDataWithoutNodes() {
        return this.defs.isDataWithoutNodes();
    }

    public void process(DollarUniverseJob job) {
        job.addAttribute("IS_REFERENCE", "1");
        job.addAttribute("REFERENCED_PATH", this.referencePath(job));
    }

    private String referencePath(DollarUniverseJob job) {
        String prefix = ReferencePath_Prefix + job.getNodeName();
        String referenceName = job.getUprAttribute("upr");
        if (this.defs.isDataWithoutNodes) {
            return ReferencePath_Prefix + referenceName;
        }
        return prefix + "/" + referenceName;
    }
}

