/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.utils.DollarUniverseUtils;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.List;
import java.util.Properties;

public class HandlerEndFolderDummyJobTriggeredByFolderJobs {
    private RulesDataSet rules;
    private UniqueConditionNameGenerator uniqueConditionNameGenerator;

    public HandlerEndFolderDummyJobTriggeredByFolderJobs(RulesDataSet rules, UniqueConditionNameGenerator uniqueConditionNameGenerator) {
        this.rules = rules;
        this.uniqueConditionNameGenerator = uniqueConditionNameGenerator;
    }

    public Properties getOutConditionForEndFolderJob(String uprName, String folderName) {
        Properties outCond = new Properties();
        outCond.put("NAME", this.uniqueConditionNameGenerator.getUniqueOutConditionName(this.buildConditionName(uprName, folderName)));
        outCond.put("ODATE", "ODAT");
        outCond.put("SIGN", "ADD");
        return outCond;
    }

    public Properties getInConditionForEndFolderJob(String uprName, String folderName) {
        Properties inCond = new Properties();
        inCond.put("NAME", this.buildConditionName(uprName, folderName));
        inCond.put("ODATE", "ODAT");
        inCond.put("AND_OR", "AND");
        return inCond;
    }

    private String buildConditionName(String uprName, String folderName) {
        return String.format(this.getConditionFormatForEndFolderJob(this.rules), uprName, folderName);
    }

    public String getConditionFormatForEndFolderJob(RulesDataSet rules) {
        boolean isAtoBFormat = DollarUniverseUtils.isAtoBConditionFormat(rules);
        if (isAtoBFormat) {
            return DollarUniverseGlobals.END_FOLDER_COND_NAME_NEW_FORMAT_TRIGGERED_BY_JOBS;
        }
        return DollarUniverseGlobals.END_FOLDER_COND_NAME_FORMAT_TRIGGERED_BY_JOBS;
    }

    public boolean checkIfJobHasInCondFromFW(List<Properties> InConds) {
        return InConds.stream().filter(incond -> incond.getProperty("NAME").contains("FILE_RES")).count() >= 1L;
    }

    public Properties addOutCondForEndFolderJob(String jobName, String parentName) {
        Properties outCond = this.getOutConditionForEndFolderJob(jobName, parentName);
        return outCond;
    }

    private void addInCondsToEndFolderJob(AssistingJob toRet, DollarUniverseJob parent) {
        boolean[] jobWithResconWasFound = new boolean[]{false};
        parent.getChildren().stream().forEach(child -> {
            if (child == this.findFirstChildWithInCondFromFWjob(parent) || jobWithResconWasFound[0]) {
                this.addInCondForEndFolderJob(toRet, child.getJobName(), parent.getJobName());
                jobWithResconWasFound[0] = true;
            }
        });
    }

    private SchedEntity findFirstChildWithInCondFromFWjob(DollarUniverseJob parent) {
        for (SchedEntity child : parent.getChildren()) {
            if (!this.checkIfJobHasInCondFromFW(child.getInConds())) continue;
            return child;
        }
        return null;
    }

    private void addInCondForEndFolderJob(AssistingJob toRet, String jobName, String parentName) {
        UniqueConditionNameGenerator uniqueConditionNameGenerator = new UniqueConditionNameGenerator("_");
        HandlerEndFolderDummyJobTriggeredByFolderJobs handlerEndFolderDummyJob = new HandlerEndFolderDummyJobTriggeredByFolderJobs(this.rules, uniqueConditionNameGenerator);
        Properties inCond = handlerEndFolderDummyJob.getInConditionForEndFolderJob(jobName, parentName);
        toRet.addInCondition(inCond);
    }

    public AssistingJob initEndFolderJob(DollarUniverseJob job) {
        AssistingJob toRet = new AssistingJob(SchedEntity.TYPE.JOB);
        toRet.setAttribute("JOBNAME", String.format(DollarUniverseGlobals.END_FOLDER_JOB_NAME_FORMAT, job.getParentName()));
        toRet.setAttribute("TASKTYPE", "Dummy");
        toRet.setAttribute("NODEID", job.getNodeName());
        toRet.setAttribute("END_FOLDER", "Y");
        toRet.setAttribute("DESCRIPTION", String.format(DollarUniverseGlobals.END_FOLDER_JOB_DESCRIPTION_TRIGGERED_BY_FOLDER_JOBS, job.getParentName()));
        toRet.setAttribute("APPLICATION", job.getApplication());
        toRet.setAttribute("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", job.getGroup()));
        toRet.setAttribute("OWNER", job.getAttr("OWNER"));
        toRet.setAttribute("AUTHOR", job.getAttr("AUTHOR"));
        toRet.setAttribute("PARENT_TABLE", FieldValidation.instance().validateAndReturnFixedValue("PARENT_TABLE", job.getParentName()));
        toRet.setAttribute("TAG_RELATIONSHIP", job.getAttr("TAG_RELATIONSHIP"));
        toRet.setAttribute("PRIORITY", job.getAttr("PRIORITY"));
        toRet.setM_tags(job.getTags());
        this.addInCondsToEndFolderJob(toRet, job.getParent());
        return toRet;
    }

    public void UpdateJobAndCondsNamesForEndFolderJob(AssistingJob assisting, DollarUniverseJob job) {
        List onDoStmts;
        assisting.setAttribute("JOBNAME", String.format(assisting.getAttr("JOBNAME"), job.getParentName()));
        List inConds = assisting.getInConds();
        if (inConds != null) {
            for (Properties inCond : inConds) {
                String condName = inCond.getProperty("NAME");
                String condNameWithParentName = String.format(condName, job.getParentName());
                inCond.setProperty("NAME", condNameWithParentName);
            }
        }
        if ((onDoStmts = assisting.getOnStmt()) != null) {
            for (Properties onDoStmt : onDoStmts) {
                String condName = onDoStmt.getProperty("NAME");
                String condNameWithParentName = String.format(condName, job.getParentName());
                onDoStmt.setProperty("NAME", condNameWithParentName);
            }
        }
    }
}

