/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    T data;
    private List<TreeNode<T>> children;
    private TreeNode<T> parent;

    public TreeNode(TreeNode<T> parent, T data) {
        this.data = data;
        this.parent = parent;
        this.children = new ArrayList<TreeNode<T>>();
    }

    public T getData() {
        return this.data;
    }

    void addChild(TreeNode<T> childNode) {
        this.children.add(childNode);
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Node data=" + String.valueOf(this.data)).append("\n");
        if (this.children.isEmpty()) {
            return b.toString();
        }
        b.append("Node childs={");
        for (TreeNode<T> childNode : this.children) {
            b.append(childNode.data).append("\t ");
        }
        b.append("};");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public ArrayList<T> getChildren() {
        ArrayList<T> ret = new ArrayList<T>();
        for (TreeNode<T> childNode : this.children) {
            ret.add(childNode.getData());
        }
        return ret;
    }
}

