/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Simple2csv {
    private InputStream sourceStream;
    private OutputStream targetSream2csv;
    private String entryPattern = "";
    private String fieldPattern = "\\s*(ITEMS)?\\s*\\|\\s*(\\S+)\\s*(:\\s*(.*))?";
    private String nodeName = "";
    private String nodeKey = "| NODE : ";
    private String pastNode = null;
    private boolean thereIsAnode = false;
    public String currKey;
    public StringBuilder currValue;

    protected abstract String[] getSourceKeys();

    protected abstract String[] getCsvHeader();

    public Simple2csv(File sourceFile, File targetCsv) throws FileNotFoundException {
        this(new FileInputStream(sourceFile), new FileOutputStream(targetCsv));
    }

    public Simple2csv(InputStream sourceStream, OutputStream targetSream) {
        this.sourceStream = sourceStream;
        this.targetSream2csv = targetSream;
    }

    public void setEntryPattern(String value) {
        this.entryPattern = value;
    }

    public void setFieldPattern(String value) {
        this.fieldPattern = value;
    }

    private void entries2csv(ArrayList<HashMap<String, String>> entries) throws IOException {
        CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(this.targetSream2csv), ',');
        writer.writeRecord(this.getCsvHeader());
        for (HashMap<String, String> entry : entries) {
            writer.writeRecord(this.map2arr(entry));
        }
        writer.close();
    }

    private String[] map2arr(HashMap<String, String> entry) {
        String[] toRet = new String[this.getCsvHeader().length];
        for (int i = 0; i < this.getCsvHeader().length; ++i) {
            if (!entry.containsKey(this.getCsvHeader()[i])) continue;
            toRet[i] = entry.get(this.getCsvHeader()[i]);
        }
        return toRet;
    }

    public void writeToCSV() {
        try {
            this.entries2csv(this.readEntries());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<HashMap<String, String>> readEntries() throws IOException {
        String currLine;
        ArrayList<HashMap<String, String>> toRet = new ArrayList<HashMap<String, String>>();
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(this.sourceStream));
        ArrayList<String> rawEntry = new ArrayList<String>();
        while ((currLine = inputStream.readLine()) != null) {
            this.updateToTheNextNode(currLine);
            if (currLine.trim().isEmpty() || !currLine.toUpperCase().matches(this.entryPattern)) continue;
        }
        while ((currLine = inputStream.readLine()) != null) {
            this.updateToTheNextNode(currLine);
            if (currLine.trim().isEmpty()) continue;
            if (currLine.trim().startsWith("Command :")) {
                if (!this.processEntry(rawEntry).isEmpty()) {
                    this.addTheNodeLine(rawEntry, this.pastNode);
                    toRet.add(this.processEntry(rawEntry));
                }
                rawEntry.clear();
                continue;
            }
            if (currLine.toUpperCase().matches(this.entryPattern)) {
                if (!this.processEntry(rawEntry).isEmpty()) {
                    this.addTheNodeLine(rawEntry, this.nodeName);
                    toRet.add(this.processEntry(rawEntry));
                }
                rawEntry.clear();
                continue;
            }
            rawEntry.add(currLine);
        }
        this.addTheNodeLine(rawEntry, this.nodeName);
        toRet.add(this.processEntry(rawEntry));
        inputStream.close();
        return toRet;
    }

    private void addTheNodeLine(ArrayList<String> rawEntry, String node_name) {
        Object nodeKeyValue = this.nodeKey;
        if (this.thereIsAnode) {
            if (node_name.equals(this.pastNode)) {
                nodeKeyValue = (String)nodeKeyValue + node_name;
                this.pastNode = this.nodeName;
            } else {
                nodeKeyValue = (String)nodeKeyValue + this.nodeName;
            }
        } else {
            nodeKeyValue = (String)nodeKeyValue;
        }
        rawEntry.add((String)nodeKeyValue);
    }

    private HashMap<String, String> processEntry(ArrayList<String> rawEntry) {
        HashMap<String, String> toRet = new HashMap<String, String>();
        this.currKey = "";
        this.currValue = new StringBuilder();
        for (String line : rawEntry) {
            Pattern keyValPat = Pattern.compile(this.fieldPattern);
            Matcher keyValMatch = keyValPat.matcher(line);
            if (keyValMatch.matches() && this.isKey(keyValMatch.group(2))) {
                this.currKey = keyValMatch.group(2);
                this.currValue.delete(0, this.currValue.length());
                this.currValue.append(keyValMatch.group(4));
                if (this.currKey.isEmpty()) continue;
                this.handleSpecialKey();
                toRet.put(this.currKey.toUpperCase(), this.currValue.toString());
                continue;
            }
            if (this.currKey.isEmpty()) continue;
            this.currValue.append(line);
        }
        return toRet;
    }

    protected void handleSpecialKey() {
    }

    private boolean isKey(String string) {
        for (int i = 0; i < this.getSourceKeys().length; ++i) {
            if (!this.getSourceKeys()[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void updateToTheNextNode(String line) {
        String regex = "( *)Command( *):( *)(.*)node=(\\S*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            this.thereIsAnode = true;
            String node_Name = matcher.group(5);
            if (!node_Name.isEmpty()) {
                if (this.pastNode != null) {
                    this.pastNode = this.nodeName;
                    this.nodeName = node_Name;
                } else {
                    this.pastNode = node_Name;
                    this.nodeName = node_Name;
                }
            }
        }
    }
}

