/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.NodeGroup;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSession;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntryHDPHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class SessionManipulator {
    public static final String DEFAULT_HOST_GROUP = "HostGroupPlaceholder";
    public static final String MONITORING_VAR = "Monitoring_View_Variable";
    static DollarUniverseDefs currentSourceDefinitions;
    private LinkedHashMap<Integer, DollarUniverseJob> jobMap;
    DollarUniverseSession session;
    private MuHierarchy muHierarchy;

    public SessionManipulator(DollarUniverseSession session, MuHierarchy muHierarchy, DollarUniverseDefs sourceDefinitions) {
        this.session = session;
        this.muHierarchy = muHierarchy;
        this.jobMap = new LinkedHashMap();
        currentSourceDefinitions = sourceDefinitions;
    }

    public List<NodeGroup> getNodeGroupsInSession() {
        GroupsCreator muToHostGroupCreator = currentSourceDefinitions.getHdpLogic().getHostGroupCreator();
        List<NodeGroup> hostGroups = muToHostGroupCreator.getHostGroups(this.session);
        return hostGroups;
    }

    public void manipulateJobs() {
        this.maniuplateJobsAccordingHdp();
        this.setCorrectNodeIdToJobs();
    }

    public void setCorrectNodeIdToJobs() {
        List<SessionEntry> sessionEntries = this.session.getSessionEntryList();
        for (SessionEntry sessionEntry : sessionEntries) {
            if (!this.isNeedToSetHostName(sessionEntry)) continue;
            this.setSonJobHostNameBySessionNode(sessionEntry);
        }
    }

    private void setSonJobHostNameBySessionNode(SessionEntry sessionEntry) {
        Integer sonNumber = sessionEntry.getSonNumber();
        DollarUniverseJob sonControlMJob = this.jobMap.get(sonNumber);
        sonControlMJob.updateJobHostNameAccordingToSessionNodeID();
    }

    private boolean isNeedToSetHostName(SessionEntry sessionEntry) {
        DollarUniverseJob sonControlMJob = this.jobMap.get(sessionEntry.getSonNumber());
        return sessionEntry.isValid() && !this.session.isEntryInHdpContext(sessionEntry) && sonControlMJob != null;
    }

    public void setHeader(IAttrHolder headerattributes, DollarUniverseJob headerJob) {
        SessionEntry entry = new SessionEntry(headerattributes, this.session);
        if (entry.isValid()) {
            this.jobMap.put(entry.getFatherNumber(), headerJob);
        }
    }

    public void addConvertedUprocInSession(IAttrHolder Uprocattr, DollarUniverseJob Job) {
        SessionEntry entry = new SessionEntry(Uprocattr, this.session);
        Integer uprocNumber = entry.getSonNumber();
        if (entry.isValid()) {
            this.jobMap.put(uprocNumber, Job);
        }
    }

    public void maniuplateJobsAccordingHdp() {
        if (!this.session.isSessionUsingHDP()) {
            return;
        }
        List<SessionEntry> sessionEntries = this.session.getSessionAttributeListFromFirstHdpUse();
        for (SessionEntry sessionEntry : sessionEntries) {
            SessionEntryHDPHandler entryHandler = new SessionEntryHDPHandler(this.session, sessionEntry, this.jobMap, currentSourceDefinitions);
            if (!this.isValidHdpEntry(sessionEntry)) continue;
            entryHandler.handleSessionEntry();
        }
    }

    private boolean isValidHdpEntry(SessionEntry sessionEntry) {
        return sessionEntry.isValid() && this.isEntryJobsExists(sessionEntry) && this.session.isEntryInHdpContext(sessionEntry);
    }

    private boolean isEntryJobsExists(SessionEntry sessionEntry) {
        DollarUniverseJob sonJob = this.jobMap.get(sessionEntry.getSonNumber());
        DollarUniverseJob fatherJob = this.jobMap.get(sessionEntry.getFatherNumber());
        return sonJob != null && fatherJob != null;
    }

    public String toString() {
        return "SessionManipulator:\nsessionEntryList=" + this.session.toString() + "\nJobMAp=" + String.valueOf(this.jobMap) + "]";
    }

    public static Optional<DollarUniverseDefs> getCurrentDataSource() {
        Optional<DollarUniverseDefs> returnSourceData = Optional.ofNullable(currentSourceDefinitions);
        return returnSourceData;
    }

    public static void clearCurrentDataSource() {
        currentSourceDefinitions = null;
    }

    public static interface GroupsCreator {
        public List<NodeGroup> getHostGroups(DollarUniverseSession var1);
    }
}

