/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.dollar_universe.SessionAttributeMatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SessionDetailsReader {
    private static String nodeName = "";
    private BufferedReader sessionDetailsInput;
    private String lastLine;

    public SessionDetailsReader(BufferedReader sessionDetailsInput) {
        this.sessionDetailsInput = sessionDetailsInput;
    }

    public Map<String, String> readNextSessionAttributes() {
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            String beginOfSession = this.findExpressionAndUpdateNodeName("( *)TYPE( *)\\|( *)ses( *)");
            if (beginOfSession == null) {
                return ret;
            }
            String sessionName = this.getParamValue("( *)ITEMS( *)\\|( *)ses(.*)");
            if (sessionName == null) {
                sessionName = "";
            }
            sessionName = sessionName.trim();
            ret.put("ses", sessionName);
            this.lastLine = this.readLine();
            while (this.lastLine != null && !this.endOfAttributesSection()) {
                SessionAttributeMatcher matcher = new SessionAttributeMatcher(this.lastLine);
                if (matcher.find()) {
                    String name = matcher.getSessionAttributeName();
                    String value = matcher.getSessionAttributeValue();
                    ret.put(name, value);
                }
                this.lastLine = this.readLine();
            }
            ret.put("nodeName", nodeName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private boolean endOfAttributesSection() {
        return this.lastLine.trim().equals("|");
    }

    public String findExpression(String expr) throws IOException {
        while ((this.lastLine = this.readLine()) != null) {
            if (!this.lastLine.matches(expr)) continue;
            return this.lastLine;
        }
        return null;
    }

    public String findExpressionAndUpdateNodeName(String expr) throws IOException {
        while ((this.lastLine = this.readLine()) != null) {
            String nextNodeName = this.getNextNode(this.lastLine);
            if (!nextNodeName.isEmpty()) {
                nodeName = nextNodeName;
            }
            if (!this.lastLine.matches(expr)) continue;
            return this.lastLine;
        }
        return null;
    }

    private String readLine() throws IOException {
        String readLine = this.sessionDetailsInput.readLine();
        while (readLine != null && readLine.trim().isEmpty()) {
            readLine = this.sessionDetailsInput.readLine();
        }
        if (readLine != null) {
            readLine = readLine.trim();
        }
        return readLine;
    }

    private String getNextNode(String line) {
        String regex = "( *)Command( *):( *)(.*)node=(\\S*)";
        Pattern pattern = Pattern.compile("( *)Command( *):( *)(.*)node=(\\S*)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String nodeName = matcher.group(5);
            return nodeName;
        }
        return "";
    }

    public String getParamValue(String expr) throws IOException {
        this.lastLine = this.findExpression(expr);
        if (this.lastLine == null) {
            return this.lastLine;
        }
        return this.getAttributeValue();
    }

    private String getAttributeValue() {
        int index = this.lastLine.indexOf(58);
        if (index > 0) {
            return this.lastLine.substring(index + 1).trim();
        }
        return null;
    }
}

