/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.Hdp.logic;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.Hdp.hostgroups.MuToHostGroupCreator;
import com.bmc.ctmconvert.dollar_universe.SessionManipulator;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HdpHandler;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.hdpmu.SpecificMU;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public class HdpLogicInScript
implements HdpHandler.HdpLogicHandler {
    private static final String HEADER_HOST_GROUP_AUTOEDIT = "%%HOST_GROUP";
    private static final String CONDION_ARGUMENT_VALUE = "%%ORDERID";
    public static final String HOST_GROUP_VALUE = "%%NODEGRP";
    public static final String FOLDER_ORDER_ID_VALUE = "%%$SMART_ORDERID";
    public static final String FOLDER_ARGUMENT = "-folder";
    public static final String JOB_TO_ORDER_ARGUMENT = "-job_to_order";
    public static final String RELATIONSHIP_ARGUMENT = "-relationship";
    public static final String MU_TYPE_ARGUMENT = "-MU_type";
    public static final String HOST_GROUP_ARGUMENT = "-host_group";
    public static final String CONDITION_VARIABLE_ARGUMENT = "-condition_variable";
    public static final String FOLDER_ORDER_ID = "-folder_id";
    private final MuHierarchy muHierarchy;
    private final BiFunction<String, String, String> muToPhysicalResolver;
    private final boolean isConditionNeeded;

    public HdpLogicInScript(MuHierarchy muHierarchy, BinaryOperator<String> muToPhysicalResolver, Boolean isConditionNeeded) {
        this.muHierarchy = muHierarchy;
        this.muToPhysicalResolver = muToPhysicalResolver;
        this.isConditionNeeded = isConditionNeeded;
    }

    @Override
    public SessionManipulator.GroupsCreator getHostGroupCreator() {
        return new MuToHostGroupCreator(this.muHierarchy, this.muToPhysicalResolver);
    }

    @Override
    public String getScriptMessgae(SchedEntity job, SessionEntry sessionEntry) {
        HDPRelationship hdp = sessionEntry.getHDPMU();
        String space = " ";
        StringBuilder message = new StringBuilder();
        message.append(FOLDER_ARGUMENT).append(space).append("%%SCHEDTAB").append(space);
        message.append(JOB_TO_ORDER_ARGUMENT).append(space).append(job.getJobName()).append(space);
        if (hdp instanceof SpecificMU) {
            message.append(HOST_GROUP_ARGUMENT).append(space).append(hdp.getExpression()).append(space);
        } else if (!sessionEntry.isFatherInHdpContext() || sessionEntry.isFatherAHeader()) {
            Set<String> mus = sessionEntry.getFatherMus();
            Optional firstMu = mus.stream().findFirst();
            firstMu.ifPresent(mu -> message.append(HOST_GROUP_ARGUMENT).append(space).append((String)mu).append(space));
        } else {
            message.append(HOST_GROUP_ARGUMENT).append(space).append(HOST_GROUP_VALUE).append(space);
        }
        message.append(RELATIONSHIP_ARGUMENT).append(space).append((Object)hdp.getRelationship());
        if (hdp instanceof HDPRelationship.TypedReleaionship) {
            message.append(space).append(MU_TYPE_ARGUMENT).append(space).append(((HDPRelationship.TypedReleaionship)((Object)hdp)).getType());
        }
        if (this.isConditionNeeded) {
            message.append(space).append(CONDITION_VARIABLE_ARGUMENT).append(space).append(CONDION_ARGUMENT_VALUE);
        }
        message.append(space).append(FOLDER_ORDER_ID).append(space).append(FOLDER_ORDER_ID_VALUE);
        return message.toString();
    }

    @Override
    public void handleFatherJob(DollarUniverseJob fatherJob, String headerMu) {
        fatherJob.getAutoedits().put(HEADER_HOST_GROUP_AUTOEDIT, headerMu);
    }

    @Override
    public void createHdpScriptsDir() {
        String orderJobPl = "orderJob.pl";
        String orderScriptBat = "orderscript.bat";
        String orderJobSh = "orderJob.sh";
        File orderScript = new File(Globs.SCRIPTS_DIR + Globs.DIRSEP + "DOLLAR_UNIVERSE" + Globs.DIRSEP + orderJobPl);
        File batScript = new File(Globs.SCRIPTS_DIR + Globs.DIRSEP + "DOLLAR_UNIVERSE" + Globs.DIRSEP + orderScriptBat);
        File shScript = new File(Globs.SCRIPTS_DIR + Globs.DIRSEP + "DOLLAR_UNIVERSE" + Globs.DIRSEP + orderJobSh);
        File muDependenciesFile = new File(Params.instance().getDatasourcePath() + "MuDependencies.txt");
        if (muDependenciesFile.exists()) {
            File hdpDir = new File(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "HDP");
            boolean isCreated = hdpDir.mkdir();
            if (!isCreated) {
                ConversionLogger.getLogger().warning("HDP folder : " + hdpDir.getAbsolutePath() + " failed to be created");
                return;
            }
            try {
                GlobalFunctions.copy((File)orderScript, (File)new File(hdpDir, orderJobPl));
                GlobalFunctions.copy((File)shScript, (File)new File(hdpDir, orderJobSh));
                GlobalFunctions.copy((File)batScript, (File)new File(hdpDir, orderScriptBat));
                GlobalFunctions.copy((File)muDependenciesFile, (File)new File(hdpDir, "MuDependencies.txt"));
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }
}

