/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.Hdp.hostgroups;

import com.bmc.ctmconvert.dollar_universe.NodeGroup;
import com.bmc.ctmconvert.dollar_universe.SessionManipulator;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSession;
import com.bmc.ctmconvert.dollar_universe.session.MuResolver;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class MuToHostGroupCreator
implements SessionManipulator.GroupsCreator {
    private MuHierarchy muHierarchy;
    private BiFunction<String, String, String> muToPhysicalResolver;

    public MuToHostGroupCreator(MuHierarchy muHierarchy, BiFunction<String, String, String> muToPhysicalResolver) {
        this.muHierarchy = muHierarchy;
        this.muToPhysicalResolver = muToPhysicalResolver;
    }

    @Override
    public List<NodeGroup> getHostGroups(DollarUniverseSession session) {
        List<NodeGroup> hostGroups = new ArrayList<NodeGroup>();
        MuResolver muResolver = new MuResolver(this.muHierarchy, session);
        for (SessionEntry sessionEntry : session.getSessionEntryList()) {
            if (!sessionEntry.isUsingHdp()) continue;
            String nodeName = sessionEntry.getNodeName();
            HashSet<String> fatherMus = muResolver.getUprocMus(sessionEntry.getFatherNumber());
            List<NodeGroup> parentNodeGroups = this.getHostGroups(fatherMus, nodeName);
            hostGroups.addAll(parentNodeGroups);
            HDPRelationship entryHdpmu = sessionEntry.getHDPMU();
            Map<String, Set<String>> parentTosonMus = entryHdpmu.resolveNodes(fatherMus, this.muHierarchy);
            for (Set<String> childrenMus : parentTosonMus.values()) {
                List<NodeGroup> childNodeGroups = this.getHostGroups(childrenMus, nodeName);
                hostGroups.addAll(childNodeGroups);
            }
        }
        hostGroups = this.removeDuplicatesGroups(hostGroups);
        return hostGroups;
    }

    private List<NodeGroup> removeDuplicatesGroups(List<NodeGroup> hostGroups) {
        ArrayList<NodeGroup> ret = new ArrayList<NodeGroup>();
        for (NodeGroup nodeGroup : hostGroups) {
            if (ret.contains(nodeGroup)) continue;
            ret.add(nodeGroup);
        }
        return ret;
    }

    private List<NodeGroup> getHostGroups(Set<String> mus, String nodeName) {
        ArrayList<NodeGroup> ret = new ArrayList<NodeGroup>();
        for (String mu : mus) {
            NodeGroup nodeGroup = new NodeGroup(mu);
            String physicalName = this.muToPhysicalResolver.apply(mu, nodeName);
            nodeGroup.add(physicalName);
            ret.add(nodeGroup);
        }
        return ret;
    }
}

