/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DollarUniverseSessionAttributes {
    private String nodeName;
    private String name;
    private IAttrHolder attributes;
    private AttrHolderList uprs = null;
    private HashMap<String, String> numberToUprocMap;

    public DollarUniverseSessionAttributes(IAttrHolder session) {
        this.name = session.getAttr("ID");
        this.attributes = session;
        this.uprs = new AttrHolderList();
        this.numberToUprocMap = new HashMap();
        this.nodeName = session.getAttr("node name");
        this.storeFatherName(session);
        this.storeSonName(session);
    }

    private void storeFatherName(IAttrHolder session) {
        String uprocNumber = session.getAttr("NumF");
        String uprocName = session.getAttr("Father");
        this.storeName(this.numberToUprocMap, uprocNumber, uprocName);
    }

    private void storeSonName(IAttrHolder session) {
        String uprocNumber = session.getAttr("NumS");
        String uprocName = session.getAttr("Son");
        this.storeName(this.numberToUprocMap, uprocNumber, uprocName);
    }

    public void appendUpr(IAttrHolder upr) {
        if (this.uprs == null) {
            this.uprs = new AttrHolderList();
        }
        this.uprs.add((Object)upr);
        this.storeFatherName(upr);
        this.storeSonName(upr);
        this.setUprocName(upr, "NumF", "Father");
        this.setUprocName(upr, "NumS", "Son");
    }

    public IAttrHolder getAttributes() {
        return this.attributes;
    }

    public List<String> getUsedUprs() {
        return this.numberToUprocMap.values().stream().collect(Collectors.toList());
    }

    public AttrHolderList getUprs() {
        return this.uprs;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean hasAson(String sonName) {
        String sessionSonName = this.attributes.getAttr("Son");
        if (sessionSonName != null && sonName.equals(sessionSonName)) {
            return true;
        }
        if (this.uprs != null) {
            int size = this.uprs.size();
            for (int i = 0; i < size; ++i) {
                IAttrHolder attr = (IAttrHolder)this.uprs.get(i);
                sessionSonName = attr.getAttr("Son");
                if (sessionSonName == null || !sonName.equals(sessionSonName)) continue;
                return true;
            }
        }
        return false;
    }

    private void setUprocName(IAttrHolder sessionToAdd, String numberAttr, String uprocNameAttr) {
        String sessionId = sessionToAdd.getAttr("ses");
        String uprocNumber = sessionToAdd.getAttr(numberAttr);
        String uprocName = sessionToAdd.getAttr(uprocNameAttr);
        if (!this.isNameExist(uprocName)) {
            if (this.numberToUprocMap.containsKey(uprocNumber)) {
                uprocName = this.numberToUprocMap.get(uprocNumber);
                sessionToAdd.setAttr(uprocNameAttr, uprocName);
            } else {
                this.issueUprocNotFoundMessage(numberAttr, uprocNameAttr, sessionId, uprocNumber);
            }
        }
    }

    void issueUprocNotFoundMessage(String numberAttr, String uprocNameAttr, String sessionId, String uprocNumber) {
        DollarUniverseJob.addExtReporterMessage("WRN7001", sessionId, null, null, uprocNameAttr, numberAttr, uprocNumber, sessionId);
    }

    private void storeName(HashMap<String, String> uprocNumberToUprocNameMap, String uprocNumber, String uprocName) {
        if (!uprocNumberToUprocNameMap.containsKey(uprocNumber) && this.isNameExist(uprocName)) {
            uprocNumberToUprocNameMap.put(uprocNumber, uprocName);
        }
    }

    private boolean isNameExist(String uprocName) {
        return uprocName != null && !uprocName.isEmpty();
    }

    public String getHeaderUprName() {
        return this.attributes.getAttr("header");
    }

    public String getTrailerUprName() {
        Optional largestKey = this.numberToUprocMap.keySet().stream().max(String::compareTo);
        return largestKey.map(this.numberToUprocMap::get).orElse("");
    }

    public String getUprFullName(Supplier<String> uprNameGetter) {
        Optional<Map.Entry> entry = this.numberToUprocMap.entrySet().stream().filter(it -> ((String)it.getValue()).equals(uprNameGetter.get())).findFirst();
        return entry.map(it -> (String)it.getValue() + "#" + (String)it.getKey()).orElse("");
    }
}

