/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace.entities;

import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.workspace.entities.IRBC;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RbcAPI
implements IRBC {
    private Map<String, String> hm = new HashMap<String, String>();

    public static RbcAPI createJobRBC(String calendarName) {
        RbcAPI rbcs = new RbcAPI();
        rbcs.setName(calendarName);
        return rbcs;
    }

    public static RbcAPI createEmptyRBC(String calendarName) {
        RbcAPI rbc = RbcAPI.createJobRBC(calendarName);
        rbc.addAttribute("MAXWAIT", "00");
        rbc.addAttribute("DAYS_AND_OR", "O");
        rbc.removeMonth(RBC.MONTHS.JAN);
        rbc.removeMonth(RBC.MONTHS.FEB);
        rbc.removeMonth(RBC.MONTHS.MAR);
        rbc.removeMonth(RBC.MONTHS.APR);
        rbc.removeMonth(RBC.MONTHS.MAY);
        rbc.removeMonth(RBC.MONTHS.JUN);
        rbc.removeMonth(RBC.MONTHS.JUL);
        rbc.removeMonth(RBC.MONTHS.AUG);
        rbc.removeMonth(RBC.MONTHS.SEP);
        rbc.removeMonth(RBC.MONTHS.OCT);
        rbc.removeMonth(RBC.MONTHS.NOV);
        rbc.removeMonth(RBC.MONTHS.DEC);
        rbc.addAttribute("SHIFT", "Ignore Job");
        rbc.addAttribute("RETRO", "0");
        return rbc;
    }

    public RbcAPI setMonthDays(List<Integer> monthDays) {
        String value = this.getAttributeOrEmpty("DAYS");
        this.addAttribute("DAYS", value + monthDays.stream().map(String::valueOf).collect(Collectors.joining(",")));
        return this;
    }

    public RbcAPI addMonth(RBC.MONTHS month) {
        this.setMonthEnabledOrDisabled(month, "1");
        return this;
    }

    private void setMonthEnabledOrDisabled(RBC.MONTHS month, String value) {
        switch (month) {
            case JAN: {
                this.addAttribute("JAN", value);
                break;
            }
            case FEB: {
                this.addAttribute("FEB", value);
                break;
            }
            case MAR: {
                this.addAttribute("MAR", value);
                break;
            }
            case APR: {
                this.addAttribute("APR", value);
                break;
            }
            case MAY: {
                this.addAttribute("MAY", value);
                break;
            }
            case JUN: {
                this.addAttribute("JUN", value);
                break;
            }
            case JUL: {
                this.addAttribute("JUL", value);
                break;
            }
            case AUG: {
                this.addAttribute("AUG", value);
                break;
            }
            case SEP: {
                this.addAttribute("SEP", value);
                break;
            }
            case OCT: {
                this.addAttribute("OCT", value);
                break;
            }
            case NOV: {
                this.addAttribute("NOV", value);
                break;
            }
            case DEC: {
                this.addAttribute("DEC", value);
            }
        }
    }

    public RbcAPI setActivePeriod(LocalDateTime from, LocalDateTime to) {
        if (from != null) {
            this.setActiveFromDate(DateTimeFormatter.ofPattern("yyyyMMdd").format(from));
        }
        if (to != null) {
            this.setActiveToDate(DateTimeFormatter.ofPattern("yyyyMMdd").format(to));
        }
        return this;
    }

    public void setActiveFromDate(String yyyyMMdd) {
        this.addAttribute("ACTIVE_FROM", yyyyMMdd);
    }

    public void setActiveToDate(String yyyyMMdd) {
        this.addAttribute("ACTIVE_TILL", yyyyMMdd);
    }

    public RbcAPI removeMonth(RBC.MONTHS month) {
        this.setMonthEnabledOrDisabled(month, "0");
        return this;
    }

    public RbcAPI setControlMLevel() {
        this.addAttribute("LEVEL", LEVEL.CONTROL_M.value);
        return this;
    }

    public RbcAPI setFolderLevel() {
        this.addAttribute("LEVEL", LEVEL.FOLDER.value);
        return this;
    }

    public LEVEL getLevel() {
        String level = this.hm.get("LEVEL");
        if (LEVEL.CONTROL_M.value.equals(level)) {
            return LEVEL.CONTROL_M;
        }
        if (LEVEL.FOLDER.value.equals(level)) {
            return LEVEL.FOLDER;
        }
        return null;
    }

    public void addAttribute(String attrName, String attrValue) {
        this.hm.put(attrName, attrValue);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.hm;
    }

    @Override
    public String getName() {
        return this.hm.get("NAME");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RbcAPI rbcAPI = (RbcAPI)o;
        return Objects.equals(this.hm, rbcAPI.hm);
    }

    public int hashCode() {
        return Objects.hashCode(this.hm);
    }

    public void setName(@NotNull String rbcName) {
        this.addAttribute("NAME", rbcName);
    }

    public static enum LEVEL {
        CONTROL_M("Y"),
        FOLDER("N");

        private final String value;

        private LEVEL(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

