/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace;

import com.bmc.ctmconvert.workspace.IWalkerEntityHandler;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.entities.Folder;
import java.util.List;
import java.util.Optional;

public class WorkspaceWalker {
    private Workspace workspace;
    private IWalkerEntityHandler handler;

    public WorkspaceWalker(Workspace workspace, IWalkerEntityHandler handler) {
        this.workspace = workspace;
        this.handler = handler;
    }

    public void walk() {
        List<Folder> smartFolders = this.workspace.getTopLevelFolders();
        for (Folder folder : smartFolders) {
            this.walkTree(folder, Optional.empty());
        }
    }

    private void walkTree(IWorkspaceEntity entity, Optional<Folder> parent) {
        this.handler.handleEntity(entity, parent);
        if (entity instanceof Folder) {
            this.walkOnChildren((Folder)entity);
        }
    }

    private void walkOnChildren(Folder entity) {
        List<IWorkspaceEntity> children = entity.getChildren();
        for (IWorkspaceEntity subEntity : children) {
            this.walkTree(subEntity, Optional.of(entity));
        }
    }
}

