/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.vc;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.EncodingValidator;
import com.bmc.ctmconvert.vc.IFieldValidation;
import com.bmc.ctmconvert.vc.Message;
import com.bmc.ctmconvert.vc.validationitem.FieldValidationItem;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FieldValidation
implements IFieldValidation {
    private Properties propRules;
    private boolean isMPM = true;
    private String fixedValue = null;
    private boolean valid = true;
    private ArrayList<Message> m_messages;
    public static IFieldValidation instance;
    private static String controlMValidationRules;
    private boolean checkUnique = false;
    private UniqueValueParams uniqueValueParams;

    public static IFieldValidation instance() {
        if (instance == null) {
            instance = new FieldValidation();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private FieldValidation() {
        String rulesFileName = Globs.VALIDATION_RULES_PROPERTIES_700;
        this.propRules = new Properties();
        this.m_messages = new ArrayList();
        controlMValidationRules = Params.instance().getGUIVersion();
        if (controlMValidationRules.equals("7") || controlMValidationRules.equals("8") || controlMValidationRules.equals("9")) {
            rulesFileName = Globs.VALIDATION_RULES_PROPERTIES_700;
        }
        try {
            this.propRules.load(new FileInputStream(rulesFileName));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public static String getcontrolMValidationRules() {
        return controlMValidationRules;
    }

    @Override
    public Properties getPropRules() {
        return this.propRules;
    }

    @Override
    public String getFixedValue() {
        return this.fixedValue;
    }

    private void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public String validateAndReturnFixedValue(String attribute, String value) {
        return this.validateAndReturnFixedValue(attribute, value, true, null, null, null);
    }

    @Override
    public String validateAndReturnFixedValue(String attribute, String value, boolean isMPM, String competitorAttributeName, String originalJobName, List<String> messages) {
        return this.validateAndReturnFixedValue(attribute, attribute, value, isMPM, competitorAttributeName, originalJobName, messages);
    }

    @Override
    public String validateAndReturnFixedUniqueValue(String attribute, String attributeDisplayName, String value, boolean isMPM, String competitorAttributeName, String originalJobName, ArrayList<NewMessage> messages, UniqueValueGenerator uniqueValue, String key, int maxAllowedLength, String seperator, boolean update) {
        this.checkUnique = true;
        this.uniqueValueParams = new UniqueValueParams(this, key, maxAllowedLength, seperator, update, uniqueValue);
        String retValue = this.validateAndReturnFixedValue(messages, attribute, attributeDisplayName, value, isMPM, competitorAttributeName, originalJobName);
        this.checkUnique = false;
        return retValue;
    }

    @Override
    public String validateAndReturnFixedValue(String attribute, String attributeDisplayName, String value, boolean isMPM, String competitorAttributeName, String originalJobName, List<String> messages) {
        String uniqueVal;
        if (!this.validate(attribute, value, isMPM).booleanValue()) {
            String origVal = value;
            value = this.getFixedValue();
            if (messages != null) {
                String uniqueVal2;
                if (originalJobName == null) {
                    originalJobName = "";
                }
                origVal = origVal.replaceAll("\n", "").replaceAll("\r", "");
                String valueForMessage = value.replaceAll("\n", "").replaceAll("\r", "");
                competitorAttributeName = competitorAttributeName == null ? "" : "(" + Params.instance().getVendorName() + "- " + competitorAttributeName + ")";
                ArrayList<Message> validObjectMessages = this.getErrMsgs();
                if (this.checkUnique && !valueForMessage.equals(uniqueVal2 = this.returnUniqueName(valueForMessage))) {
                    valueForMessage = uniqueVal2;
                    value = uniqueVal2;
                }
                if (!Params.instance().getGUIVersion().equals("7") && attributeDisplayName.contains("TABLE")) {
                    attributeDisplayName = attributeDisplayName.replace("TABLE", "FOLDER");
                }
                for (Message message : validObjectMessages) {
                    if (message.getMsgType() == Message.MessageType.LENGTH) {
                        Reporter.addMessage(messages, "INF0013", originalJobName, attributeDisplayName, competitorAttributeName, origVal, valueForMessage);
                        continue;
                    }
                    if (message.getMsgType() != Message.MessageType.INVALID_CHARACTER) continue;
                    Reporter.addMessage(messages, "INF0014", originalJobName, attributeDisplayName, competitorAttributeName, origVal, valueForMessage);
                }
            }
        } else if (this.checkUnique && (uniqueVal = this.returnUniqueName(value)) != null && !uniqueVal.equals(value)) {
            value = uniqueVal;
        }
        return value;
    }

    private String returnUniqueName(String testedVal) {
        return this.uniqueValueParams.getUniqueValueObject().getUniqueValue(this.uniqueValueParams.getKey(), testedVal, this.uniqueValueParams.getMaxAllowedLength(), this.uniqueValueParams.getSeperator(), this.uniqueValueParams.getUpdate());
    }

    @Override
    public String validateAndReturnFixedValue(MessageHandler handler, String attribute, String value, boolean isMPM, String competitorAttributeName) {
        if (!this.validate(attribute, value, isMPM).booleanValue()) {
            String origVal = value;
            value = this.getFixedValue();
            if (handler != null) {
                origVal = origVal.replaceAll("\n", "").replaceAll("\r", "");
                String valueForMessage = value.replaceAll("\n", "").replaceAll("\r", "");
                competitorAttributeName = competitorAttributeName == null ? "" : "(" + Params.instance().getVendorName() + "- " + competitorAttributeName + ")";
                ArrayList<Message> validObjectMessages = this.getErrMsgs();
                for (Message message : validObjectMessages) {
                    if (message.getMsgType() == Message.MessageType.LENGTH) {
                        handler.handleMessage("INF0013", attribute, competitorAttributeName, origVal, valueForMessage);
                        continue;
                    }
                    if (message.getMsgType() != Message.MessageType.INVALID_CHARACTER) continue;
                    handler.handleMessage("INF0014", attribute, competitorAttributeName, origVal, valueForMessage);
                }
            }
        }
        return value;
    }

    private String overrideAttributeName(String attribute) {
        switch (attribute) {
            case "WEEKSCAL": 
            case "CONFCAL": 
            case "DAYSCAL": {
                attribute = "CAL_NAME";
            }
        }
        return attribute;
    }

    @Override
    public Boolean validate(String field, String value) {
        this.isMPM = true;
        return this.validate(field, value, this.isMPM);
    }

    @Override
    public Boolean validate(String field, String value, boolean isMPM) {
        field = this.overrideAttributeName(field);
        this.isMPM = isMPM;
        this.m_messages.clear();
        this.setFixedValue(value);
        this.setValid(true);
        FieldValidationItem item = new FieldValidationItem(isMPM, this.propRules, field);
        if (item.hasValidationRule()) {
            this.checkMinMaxBorders(item.getMinSize(), item.getMaxSize());
            this.checkPattern(item.getPattern());
            if (!item.isSupportNonLatin1()) {
                this.checkForNonLatin1Characters(value);
            }
        } else {
            this.m_messages.add(new Message(Message.MessageType.NOT_FOUND));
            this.setValid(false);
        }
        return this.isValid();
    }

    @Override
    public void validate(String field, String value, boolean isMPM, MessageHandler handler) {
        if (this.validate(field, value, isMPM).booleanValue()) {
            return;
        }
        ArrayList<Message> errMsgs = this.getErrMsgs();
        for (Message message : errMsgs) {
            Message.MessageType type = message.getMsgType();
            if (type == Message.MessageType.LENGTH) {
                handler.handleMessage("INF0021", field, value);
            }
            if (type != Message.MessageType.INVALID_CHARACTER) continue;
            handler.handleMessage("INF0020", field);
        }
    }

    private String replaceNonLatin1Character(Character theChar) {
        EncodingValidator validator = new EncodingValidator();
        if (validator.isValidLatin1(theChar.charValue())) {
            return theChar.toString();
        }
        return "_";
    }

    private char toChar(int c) {
        return (char)c;
    }

    private void checkForNonLatin1Characters(String value) {
        boolean isValidLatin1 = new EncodingValidator().isValidLatin1(value);
        if (isValidLatin1) {
            return;
        }
        this.replaceNonLatin1Characters(this.getFixedValue());
        this.m_messages.add(new Message(Message.MessageType.INVALID_CHARACTER));
        this.setValid(false);
    }

    private void replaceNonLatin1Characters(String currentFixedValue) {
        String newFixedValue = currentFixedValue.chars().mapToObj(this::toChar).map(this::replaceNonLatin1Character).collect(Collectors.joining());
        this.setFixedValue(newFixedValue);
    }

    private void checkMinMaxBorders(String minValue, String maxValue) {
        String tempValue = this.getFixedValue();
        if (GlobalFunctions.isNumber(minValue) && tempValue.length() < Integer.valueOf(minValue)) {
            this.setValid(false);
        }
        if (GlobalFunctions.isNumber(maxValue) && tempValue.length() > Integer.valueOf(maxValue)) {
            this.setFixedValue(tempValue.substring(0, Integer.parseInt(maxValue)));
            this.setValid(false);
            this.m_messages.add(new Message(Message.MessageType.LENGTH));
        }
    }

    @Override
    public ArrayList<Message> getErrMsgs() {
        return this.m_messages;
    }

    private void checkPattern(String patternValue) {
        String tempValue = this.getFixedValue();
        if (patternValue == null || patternValue.equals("[]") || patternValue.isEmpty()) {
            return;
        }
        if (patternValue.equals("[a-zA-Z]")) {
            Pattern pattern = Pattern.compile("[^a-zA-Z]");
            Matcher matcher = pattern.matcher(tempValue);
            while (matcher.find()) {
                tempValue = tempValue.replace(matcher.group(0), "_");
                this.setFixedValue(tempValue);
                this.setValid(false);
                this.m_messages.add(new Message(Message.MessageType.INVALID_CHARACTER));
            }
        } else if (patternValue.startsWith("[^")) {
            Pattern pattern = Pattern.compile(patternValue);
            Matcher matcher = pattern.matcher(tempValue);
            while (matcher.find()) {
                tempValue = tempValue.replace(matcher.group(0), "_");
                this.setFixedValue(tempValue);
                this.setValid(false);
                this.m_messages.add(new Message(Message.MessageType.INVALID_CHARACTER));
            }
        } else {
            char[] list;
            patternValue = patternValue.substring(1, patternValue.length() - 1);
            for (char chr : list = patternValue.toCharArray()) {
                if (tempValue.indexOf(chr) == -1) continue;
                tempValue = tempValue.replace(chr, '_');
                this.setFixedValue(tempValue);
                this.setValid(false);
                this.m_messages.add(new Message(Message.MessageType.INVALID_CHARACTER));
            }
        }
    }

    @Override
    public void cmdLineValidateAndReportMessages(String cmdLine, String jobName, ArrayList<String> messagesList) {
        if (!this.validate("CMDLINE", cmdLine).booleanValue()) {
            ArrayList<Message> validObjectMessages = this.getErrMsgs();
            for (Message message : validObjectMessages) {
                if (message.getMsgType() == Message.MessageType.LENGTH) {
                    String messageType = "WRN1005";
                    Reporter.addMessage(messagesList, messageType, jobName, Integer.toString(cmdLine.length()), Integer.toString(512));
                    continue;
                }
                if (message.getMsgType() != Message.MessageType.INVALID_CHARACTER) continue;
                Reporter.addMessage(messagesList, "INF0016", jobName, new String[0]);
            }
        }
    }

    @Override
    public void validateAndReportMessages(String Type2, String value, WorkspaceEntity job) {
        if (!this.validate(Type2, value).booleanValue()) {
            for (Message message : this.getErrMsgs()) {
                if (message.getMsgType() == Message.MessageType.LENGTH) {
                    if (Type2.equals("MEMNAME")) {
                        job.addMessage("INF0019", Integer.toString(value.length()));
                    }
                    if (Type2.equals("MEMLIB")) {
                        job.addMessage("INF0018", Integer.toString(value.length()));
                        continue;
                    }
                    ConversionLogger.getLogger().info("Need to generate a unique message for every attribute");
                    continue;
                }
                if (message.getMsgType() != Message.MessageType.INVALID_CHARACTER) continue;
                job.addMessage("INF0020", Type2);
            }
        }
    }

    @Override
    public String validateAndReturnFixedValue(List<NewMessage> messages, String attribute, String attributeDisplayName, String value, boolean isMPM, String competitorAttributeName, String originalValue) {
        ArrayList<String> oldMessages = new ArrayList<String>();
        String result = "";
        result = this.validateAndReturnFixedValue(attribute, attributeDisplayName, value, isMPM, competitorAttributeName, originalValue, oldMessages);
        for (String message : oldMessages) {
            String[] messageParamsArray = message.split(",");
            String messageId = messageParamsArray[0];
            String[] messageParams = Arrays.copyOfRange(messageParamsArray, 7, messageParamsArray.length);
            messages.add(new NewMessage(messageId, messageParams));
        }
        return result;
    }

    @Override
    public FieldValidationItem getValidationItem(String field) {
        return new FieldValidationItem(true, this.propRules, field);
    }

    static {
        controlMValidationRules = "7";
    }

    class UniqueValueParams {
        private String key;
        private int maxAllowedLength;
        private String seperator;
        private boolean update;
        private UniqueValueGenerator uniqueValue;

        public UniqueValueParams(FieldValidation this$0, String key, int maxAllowedLength, String seperator, boolean update, UniqueValueGenerator uniqueValue) {
            this.key = key;
            this.maxAllowedLength = maxAllowedLength;
            this.seperator = seperator;
            this.update = update;
            this.uniqueValue = uniqueValue;
        }

        public String getKey() {
            return this.key;
        }

        public int getMaxAllowedLength() {
            return this.maxAllowedLength;
        }

        public String getSeperator() {
            return this.seperator;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean getUpdate() {
            return this.update;
        }

        public UniqueValueGenerator getUniqueValueObject() {
            return this.uniqueValue;
        }
    }
}

