/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.services.settings;

import com.bmc.ctmconvert.services.settings.Feature;
import com.bmc.ctmconvert.services.settings.SettingsTable;

public enum SettingsBooleanKeys implements Feature
{
    SKIP_DRAFT_VALIDATION("N"),
    COMPARE_TO_LAST_VERSION_THROUGH_FTP("Y"),
    SAP_AUTOMATIC_IMPORT_TRACE("N"),
    MESSAGES_MAPPING_FOR_EM_VALIDATION("Y"),
    ENABLE_CONVERSION_BUILDER("N"),
    ENABLE_UTF8_DRAFT("Y"),
    JSON_DRAFT_FORMAT("N"),
    SAAS_DRAFT_FORMAT("N"),
    ENABLE_XML_CALENDAR_FILE("N"),
    ZENA_EMAIL_TASK_TO_ONDO("Y"),
    ZENA_CTMORDER_AS_EMBEDDED_SCRIPT("Y"),
    SHOULD_LOAD_REDWOOD_CPS("N");

    private String defaultValue;
    private final String originalDefaultValue;

    private SettingsBooleanKeys(String defaultValue) {
        this.defaultValue = this.originalDefaultValue = defaultValue;
    }

    public static boolean isOnPremise() {
        return !SettingsBooleanKeys.isSaas();
    }

    public static boolean isSaas() {
        return SAAS_DRAFT_FORMAT.isEnabled() && JSON_DRAFT_FORMAT.isEnabled();
    }

    public static boolean isXmlCalendarFileEnabled() {
        return ENABLE_XML_CALENDAR_FILE.isEnabled();
    }

    @Override
    public boolean getDefaultValue() {
        return this.defaultValue.equals("Y");
    }

    @Override
    public boolean isEnabled() {
        return SettingsTable.instance().getProperty(this);
    }

    public void enable() {
        this.setValueForTesting("Y");
    }

    private void setValueForTesting(String value) {
        this.defaultValue = value;
        SettingsTable.instance().setProperty(this, this.getDefaultValue());
    }

    public void disable() {
        this.setValueForTesting("N");
    }

    void resetToDefaultValue() {
        this.setValueForTesting(this.originalDefaultValue);
    }
}

