/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.services;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class FilesManager {
    FileSystem fileSystems;

    public FilesManager() {
        this(FileSystems.getDefault());
    }

    public FilesManager(FileSystem fileSystem) {
        this.fileSystems = fileSystem;
    }

    public void copyFileToDirectory(Path srcFile, Path destDir) throws IOException {
        File pathAsFile = new File(srcFile.toString());
        String fileName = pathAsFile.getName();
        InputStream srcInputStream = Files.newInputStream(srcFile, new OpenOption[0]);
        Files.copy(srcInputStream, destDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
    }

    public void createFolder(Path path) throws IOException {
        Files.createDirectory(path, new FileAttribute[0]);
    }

    public void deleteDirectory(Path directoryToBeDeleted) throws IOException {
        if (Files.notExists(directoryToBeDeleted, new LinkOption[0])) {
            throw new NoSuchFileException(directoryToBeDeleted.toString());
        }
        Files.walkFileTree(directoryToBeDeleted, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    Files.setAttribute(file, "dos:readonly", false, new LinkOption[0]);
                }
                catch (IllegalArgumentException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                }
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void extractDirIntoDir(final Path sourceDir, final Path destDir) throws IOException {
        if (Files.notExists(sourceDir, new LinkOption[0])) {
            throw new NoSuchFileException(sourceDir.toString());
        }
        if (Files.notExists(destDir, new LinkOption[0])) {
            throw new NoSuchFileException(destDir.toString());
        }
        Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String source = sourceDir.toString();
                String withoutSource = file.toString().replace(source + Globs.DIRSEP, "");
                Path destFile = destDir.resolve(withoutSource);
                Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(sourceDir)) {
                    return FileVisitResult.CONTINUE;
                }
                String source = sourceDir.toString();
                String withoutRoot = dir.toString().replace(source + Globs.DIRSEP, "");
                Path dest = destDir.resolve(withoutRoot);
                if (Files.notExists(dest, new LinkOption[0])) {
                    Files.createDirectory(dest, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

