/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.scriptelement;

import com.bmc.ctmconvert.common.xml.XmlElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathNodes;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CtmXmlElement {
    private final XmlElement xmlElement;

    public CtmXmlElement(XmlElement xmlElement) {
        this.xmlElement = xmlElement;
    }

    public CtmXmlElement(Element element) {
        this.xmlElement = new XmlElement(element);
    }

    public XmlElement getXmlElement() {
        return this.xmlElement;
    }

    public List<CtmXmlElement> getDirectChildsElementbyName(String elementName) {
        List<XmlElement> directchildsElementbyNameList = this.xmlElement.getDirectchildsElementbyName(elementName);
        return this.convertToCtmXmlElementList(directchildsElementbyNameList);
    }

    public String getValueOfFirstChildElementByName(String ... tagName) {
        return this.xmlElement.getValueOfFirstChildElementByName(tagName);
    }

    public List<CtmXmlElement> getAllDirectChildsElements() {
        List<XmlElement> allDirectchildsElement = this.xmlElement.getAllDirectchildsElement();
        return this.convertToCtmXmlElementList(allDirectchildsElement);
    }

    public String getAttribute(String attributeName) {
        return this.xmlElement.getAttribute(attributeName);
    }

    public List<String> getDirectChildsElementAttrByName(String elementName, String attributeName) {
        ArrayList directChildsElementAttrByName = this.xmlElement.getDirectChildsElementAttrByName(elementName, attributeName);
        return directChildsElementAttrByName != null ? directChildsElementAttrByName : new ArrayList();
    }

    public CtmXmlElement getFirstChildElementByName(String elementName) {
        XmlElement firstChildElementByName = this.xmlElement.getFirstChildElementByName(elementName);
        return firstChildElementByName == null ? null : new CtmXmlElement(firstChildElementByName);
    }

    public List<CtmXmlElement> getAllDecnedElementByName(String elementName) {
        List<XmlElement> allDecnedElementByName = this.xmlElement.getAllDecnedElementByName(elementName);
        return this.convertToCtmXmlElementList(allDecnedElementByName);
    }

    public String getTagName() {
        return this.xmlElement.getTagName();
    }

    public CtmXmlElement getFirstChildElementByAttrValue(String elementName, String attributeName, String attributeValue) {
        XmlElement firstChildElementByAttrValue = this.xmlElement.getFirstChildElementByAttrValue(elementName, attributeName, attributeValue);
        return firstChildElementByAttrValue == null ? null : new CtmXmlElement(firstChildElementByAttrValue);
    }

    public boolean hasAttribute(String attributeName) {
        return this.xmlElement.hasAttribute(attributeName);
    }

    public boolean hasAttributeWithValue(String attributeName, String attributeValue) {
        return this.xmlElement.hasAttributeWithValue(attributeName, attributeValue);
    }

    public CtmXmlElement getParent() {
        XmlElement parent = this.xmlElement.getParent();
        return parent == null ? null : new CtmXmlElement(parent);
    }

    public String getText() {
        return this.xmlElement.getText();
    }

    public int hashCode() {
        return this.xmlElement.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof CtmXmlElement) {
            CtmXmlElement ctmXmlElement = (CtmXmlElement)obj;
            result = this.xmlElement.equals(ctmXmlElement.xmlElement);
        }
        return result;
    }

    private List<CtmXmlElement> convertToCtmXmlElementList(List<XmlElement> list) {
        return list.stream().map(CtmXmlElement::new).collect(Collectors.toList());
    }

    public String getCData() {
        return this.xmlElement.getCData();
    }

    public List<CtmXmlElement> getByXpath(String xpathQuery) throws XPathExpressionException {
        XPathExpression expression = XPathFactory.newInstance().newXPath().compile(xpathQuery);
        if (this.xmlElement.getElement() == null) {
            return Collections.emptyList();
        }
        XPathNodes nodes = expression.evaluateExpression(this.xmlElement.getElement(), XPathNodes.class);
        Stream<Node> nodesStream = StreamSupport.stream(nodes.spliterator(), true);
        return nodesStream.filter(n -> n.getNodeType() == 1).map(Element.class::cast).map(CtmXmlElement::new).collect(Collectors.toList());
    }
}

