/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import java.util.HashMap;
import java.util.Map;

public class Step {
    private Map<String, String> autoedits;
    private int stepNumber;
    private String program;
    private String variant;
    private String owner;
    private String language;
    private String printCopies = null;
    private String printDest = null;
    private String recipient = null;
    private String listText = null;
    private String printImmed = null;
    private String printRelease = null;
    private String newListId = null;
    private String printNumLines = null;
    private String printNumColumns = null;
    private String printLayout = null;
    private String printBannerPage = null;
    private String printBanner = null;
    private String listName = null;
    private String dept = null;
    private String printAuth = null;
    private String printArchmode = null;
    private String printHostBanner = null;
    private String archiveSapObject = null;
    private String archiveObject = null;
    private String archiveInfo = null;
    private String archiveText = null;
    private String printExpiration;

    public Step(int stepNumber, String program, String variant) {
        this(stepNumber);
        this.setProgram(program);
        this.setVariant(variant);
    }

    public Step(int stepNumber) {
        this.setNumber(stepNumber);
        this.autoedits = new HashMap<String, String>();
        this.initDefault();
    }

    private void setNumber(int stepNumber) {
        this.stepNumber = stepNumber;
    }

    public void setVariant(String variant) {
        if (variant != null) {
            this.variant = variant;
        }
    }

    public void setProgram(String program) {
        if (program != null) {
            this.program = program;
        }
    }

    private void initDefault() {
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", "N");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PROGRAM", "N");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", "1");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", "X");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", "8");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE", "Print");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", "N");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-STEP_TYPE", "A");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", "N");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", "D");
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", "D");
    }

    private void addAutoEdit(String autoEditKeyFormat, String autoEditValue) {
        this.autoedits.put(String.format(autoEditKeyFormat, this.stepNumber), autoEditValue);
    }

    public Map<String, String> getAutoedits() {
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PROGRAM", this.program);
        this.addAutoEdit("%%%%SAPR3-STEP-S%02d-VAR-NAME", this.variant);
        if (this.printCopies != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", this.printCopies);
        }
        if (this.printDest != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_DEST", this.printDest);
        }
        if (this.owner != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-OWNER", this.owner);
        }
        if (this.language != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-LANGU", this.language);
        }
        if (this.recipient != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_RECIPIENT", this.recipient);
        }
        if (this.listText != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-LIST_TEXT", this.listText);
        }
        if (this.printImmed != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", this.printImmed);
        }
        if (this.printRelease != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", this.printRelease);
        }
        if (this.newListId != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", this.newListId);
        }
        if (this.printNumLines != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES", this.printNumLines);
        }
        if (this.printNumColumns != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS", this.printNumColumns);
        }
        if (this.printLayout != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_LAYOUT", this.printLayout);
        }
        if (this.printExpiration != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", this.printExpiration);
        }
        if (this.printBannerPage != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", this.printBannerPage);
        }
        if (this.printBanner != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", this.printBanner);
        }
        if (this.listName != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-LIST_NAME", this.listName);
        }
        if (this.dept != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-DEPT", this.dept);
        }
        if (this.printAuth != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_AUTH", this.printAuth);
        }
        if (this.printArchmode != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE", this.printArchmode);
        }
        if (this.printHostBanner != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", this.printHostBanner);
        }
        if (this.archiveSapObject != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-ARCHIVE_SAPOBJECT", this.archiveSapObject);
        }
        if (this.archiveObject != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-ARCHIVE_OBJECT", this.archiveObject);
        }
        if (this.archiveInfo != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-ARCHIVE_INFO", this.archiveInfo);
        }
        if (this.archiveText != null) {
            this.addAutoEdit("%%%%SAPR3-STEP-S%02d-ARCH_TEXT", this.archiveText);
        }
        return new HashMap<String, String>(this.autoedits);
    }

    public String getProgram() {
        return this.program;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setPrintCopies(String printCopies) {
        this.printCopies = printCopies;
    }

    public void setPrintDest(String printDest) {
        this.printDest = printDest;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setLang(String language) {
        this.language = language;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setListText(String listText) {
        this.listText = listText;
    }

    public void setPrintImmed(String printImmed) {
        this.printImmed = printImmed;
    }

    public void setPrintRelease(String printRelease) {
        this.printRelease = printRelease;
    }

    public void setNewListId(String newListId) {
        this.newListId = newListId;
    }

    public void setPrintNumLines(String printNumLines) {
        this.printNumLines = printNumLines;
    }

    public void setPrintNumColumns(String printNumColumns) {
        this.printNumColumns = printNumColumns;
    }

    public void setPrintLayout(String printLayout) {
        this.printLayout = printLayout;
    }

    public void setPrintBannerPage(String printBannerPage) {
        this.printBannerPage = printBannerPage;
    }

    public void setPrintBanner(String printBanner) {
        this.printBanner = printBanner;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }

    public void setPrintAuth(String printAuth) {
        this.printAuth = printAuth;
    }

    public void setPrintArchmode(String printArchmode) {
        this.printArchmode = printArchmode;
    }

    public void setPrintHostBanner(String printHostBanner) {
        this.printHostBanner = printHostBanner;
    }

    public void setArchiveSapObject(String archiveSapObject) {
        this.archiveSapObject = archiveSapObject;
    }

    public void setArchiveObject(String archiveObject) {
        this.archiveObject = archiveObject;
    }

    public void setArchiveInfo(String archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public void setArchiveText(String archiveText) {
        this.archiveText = archiveText;
    }

    public void setPrintExpiration(String printExpiration) {
        this.printExpiration = printExpiration;
    }
}

