/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.progress;

import com.bmc.ctmconvert.progress.ProgressEvent;
import com.bmc.ctmconvert.progress.ProgressListener;
import java.util.HashSet;
import java.util.Set;

public abstract class Progressable
implements Runnable {
    private Set<ProgressListener> listeners = new HashSet<ProgressListener>();
    private ProgressStatus progressStatus = ProgressStatus.RUNNING;
    private String progressStep;
    private long progressMax;
    private long progressCurrent;
    private String progressUnit;

    public void stop() {
        this.setStatus(ProgressStatus.STOPED);
    }

    public boolean isStopped() {
        return this.progressStatus == ProgressStatus.STOPED;
    }

    public String getID() {
        return "";
    }

    public String getTitle() {
        return "";
    }

    protected void setProgressStep(String step) {
        this.progressStep = step;
        this.setProgressMax(0L);
        this.setCurrentProgress(0L);
        this.fireProgressEvent(new ProgressEvent(this, ProgressEvent.ProgressType.PROGRESS_STEP, this.progressStep, this.getID()));
    }

    protected void setProgressMax(long max) {
        this.progressMax = max;
        this.fireProgressEvent(new ProgressEvent(this, ProgressEvent.ProgressType.PROGRESS_MAX, String.valueOf(this.progressMax), this.getID()));
    }

    protected void setCurrentProgress(long current) {
        this.progressCurrent = current;
        this.fireProgressEvent(new ProgressEvent(this, ProgressEvent.ProgressType.PROGRESS, String.valueOf(this.progressCurrent), this.getID()));
    }

    public ProgressStatus getStatus() {
        return this.progressStatus;
    }

    public void setProgressUnit(String progressUnit) {
        this.progressUnit = progressUnit;
        this.fireProgressEvent(new ProgressEvent(this, ProgressEvent.ProgressType.PROGRESS_UNIT, progressUnit, this.getID()));
    }

    public String getProgressUnit() {
        return this.progressUnit;
    }

    public void setStatus(ProgressStatus newStatus) {
        switch (this.progressStatus.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                if (newStatus != ProgressStatus.ENDED_STOPED && newStatus != ProgressStatus.ENDED_FAILURE && newStatus != ProgressStatus.ENDED_SUCCESS && newStatus != ProgressStatus.ENDED_WITH_MESSAGE) break;
                this.progressStatus = newStatus;
                this.fireProgressEvent(new ProgressEvent((Object)this, newStatus, this.getID()));
                break;
            }
            default: {
                this.progressStatus = newStatus;
                this.fireProgressEvent(new ProgressEvent((Object)this, newStatus, this.getID()));
            }
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireProgressEvent(ProgressEvent evt) {
        for (ProgressListener progressListener : this.listeners) {
            progressListener.updateProgress(evt);
        }
    }

    public static enum ProgressStatus {
        RUNNING,
        ENDED_SUCCESS,
        ENDED_FAILURE,
        ENDED_STOPED,
        ENDED_WITH_MESSAGE,
        STOPED,
        PENDING;

    }
}

