/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.db;

import com.bmc.ctmconvert.common.SchedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DbSqlWrapper {
    private final SchedEntity job;

    public DbSqlWrapper(SchedEntity job) {
        this.job = job;
        this.job.addAttribute("TASKTYPE", "Job");
        this.job.addAttribute("APPL_FORM", "Databases");
        this.job.addAttribute("APPL_TYPE", "DATABASE");
        this.job.addAttribute("APPL_VER", "9.0.00");
        this.job.addAttribute("CM_VER", "9.0.00");
    }

    public DbSqlWrapper convertToDbSqlJob() {
        this.setDefaultValues("Open Query");
        return this;
    }

    public DbSqlWrapper convertToStoredProcedureDatabaseJob(String storedProcedureName) {
        this.setDefaultValues("Stored Procedure");
        this.job.addAutoEdits("%%DB-STP_NAME", storedProcedureName);
        return this;
    }

    public void setDefaultValues(String databaseExecType) {
        this.job.addAutoEdits("%%DB-ACCOUNT", "DB_DEFAULT_CONNECTION");
        this.job.addAutoEdits("%%DB-EXEC_TYPE", databaseExecType);
        this.job.addAutoEdits("%%DB-SSIS_PACKAGE_SOURCE", "SQL Server");
        this.job.addAutoEdits("%%DB-APPEND_LOG", "Y");
        this.job.addAutoEdits("%%DB-APPEND_OUTPUT", "N");
        this.job.addAutoEdits("%%DB-STP_PACKAGE", "*");
        this.job.addAutoEdits("%%DB-OUTPUT_FORMAT", "Text");
        this.job.addAutoEdits("%%DB-AUTOCOMMIT", "N");
    }

    public DbSqlWrapper addSqlQuery(String query) {
        query = query.replaceAll("\r?\n", "%4E");
        int QUERY_MAX_LENGHT = 214;
        if (query.length() > 214) {
            ArrayList<String> queryList = new ArrayList<String>();
            for (int i = 0; i < query.length(); i += 214) {
                queryList.add(query.substring(i, Math.min(i + 214, query.length())).trim());
            }
            this.setMultipleDataBaseQuery(queryList);
        } else {
            this.job.addAutoEdits("%%DB-QTXT-N001-SUBQTXT", query);
            this.job.addAutoEdits("%%DB-QTXT-N001-SUBQLENGTH", Integer.toString(query.length()));
        }
        return this;
    }

    private void setMultipleDataBaseQuery(List<String> queryList) {
        AtomicInteger atomicCounter = new AtomicInteger(1);
        queryList.forEach(query -> {
            int counter = atomicCounter.getAndIncrement();
            String dataBaseQueryValue = String.format("%%%%DB-QTXT-N%03d-SUBQTXT", counter);
            String dataBaseQueryLenght = String.format("%%%%DB-QTXT-N%03d-SUBQLENGTH", counter);
            this.job.addAutoEdits(dataBaseQueryValue, (String)query);
            this.job.addAutoEdits(dataBaseQueryLenght, Integer.toString(query.length()));
        });
    }

    public DbSqlWrapper setConnectionProfile(String connectionProfile) {
        this.job.addAutoEdits("%%DB-ACCOUNT", connectionProfile);
        return this;
    }

    public DbSqlWrapper setAppendOutputTo(OutputFormat outputFormat) {
        this.job.addAutoEdits("%%DB-APPEND_OUTPUT", "Y");
        this.job.addAutoEdits("%%DB-OUTPUT_FORMAT", outputFormat.toXmlValue());
        if (outputFormat.equals((Object)OutputFormat.CSV)) {
            this.job.addAutoEdits("%%DB-CSV_SEPERATOR", ",");
        }
        return this;
    }

    public static enum OutputFormat {
        TEXT,
        XML,
        CSV,
        HTML;


        public String toXmlValue() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Text";
                case 1 -> "XML";
                case 2 -> "CSV";
                case 3 -> "HTML";
            };
        }
    }
}

