/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopBaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopOptionsFactory;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopOption;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopSqoopJob;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HadoopSqoopJobAdapter
extends HadoopBaseJobAdapter<HadoopSqoopJob.Type> {
    private static final Pattern SCOOP_OPTIONS_PATTERN = Pattern.compile("HDP-PROP-N([0-9]{3})-(NAME|VAL)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.getAllUsedVariablesInHadoopBasejob();
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getSqoopCommand()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getSqoopFiles()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getSqoopArchive()));
        Stream.ofNullable(this.getSqoopOptions()).forEach(option -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(option.toString())));
        return usedVariablesFromStr;
    }

    public HadoopSqoopJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseHadoopJob buildBaseHadoopJob() {
        return new HadoopSqoopJob().withSqoopCommand(this.getSqoopCommand()).withSqoopOptions(this.getSqoopOptions()).withSqoopArchives(this.getSqoopArchive()).withSqoopFiles(this.getSqoopFiles());
    }

    private String getSqoopFiles() {
        return this.schedEntity.getVariable("%%HDP-FILES");
    }

    private List<HadoopOption> getSqoopOptions() {
        return new HadoopOptionsFactory().getOptions(this.getVariablesAdapter(), SCOOP_OPTIONS_PATTERN);
    }

    private String getSqoopArchive() {
        return this.schedEntity.getVariable("%%HDP-ARCHIVES");
    }

    private String getSqoopCommand() {
        return this.schedEntity.getVariable("%%HDP-SQOOP_COMMAND");
    }

    @Override
    public HadoopSqoopJob.Type getType() {
        return HadoopSqoopJob.Type.JOB_HADOOP_SQOOP;
    }
}

