/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopBaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopOptionsFactory;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopHiveJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopOption;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HadoopHiveJobAdapter
extends HadoopBaseJobAdapter<HadoopHiveJob.Type> {
    private static final Pattern HIVE_OPTIONS_PATTERN = Pattern.compile("HDP-PROP-N([0-9]{3})-(NAME|VAL)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.getAllUsedVariablesInHadoopBasejob();
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getHiveScript()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getHiveArchive()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getHiveFiles()));
        Stream.ofNullable(this.getOptions()).forEach(option -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(option.toString())));
        return usedVariablesFromStr;
    }

    public HadoopHiveJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseHadoopJob buildBaseHadoopJob() {
        return new HadoopHiveJob().withHiveScript(this.getHiveScript()).withHiveOptions(this.getOptions()).withHiveArchives(this.getHiveArchive()).withHiveFiles(this.getHiveFiles());
    }

    private String getHiveFiles() {
        return this.schedEntity.getVariable("%%HDP-FILES");
    }

    private String getHiveArchive() {
        return this.schedEntity.getVariable("%%HDP-ARCHIVES");
    }

    private List<HadoopOption> getOptions() {
        return new HadoopOptionsFactory().getOptions(this.getVariablesAdapter(), HIVE_OPTIONS_PATTERN);
    }

    private String getHiveScript() {
        return this.schedEntity.getVariable("%%HDP-HIVE_SCRIPT_NAME");
    }

    @Override
    public HadoopHiveJob.Type getType() {
        return HadoopHiveJob.Type.JOB_HADOOP_HIVE;
    }
}

