/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.BaseDatabaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseDatabaseJob;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import com.bmc.ctmconvert.generated.json.models.job_types.EmbeddedQueryJob;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EmbeddedQueryJobAdapter
extends BaseDatabaseJobAdapter<EmbeddedQueryJob.Type> {
    private static final Pattern DB_QUERY_PATTERN = Pattern.compile("DB-QTXT-N[0-9]{3}-SUBQTXT");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        return this.variablesAdapter.getUsedVariablesFromStr(this.getQuery());
    }

    public EmbeddedQueryJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseDatabaseJob buildBaseDatabaseJob() {
        return new EmbeddedQueryJob().withQuery(this.getQuery());
    }

    private String getQuery() {
        List<Variable> cmVariables = this.getVariablesAdapter().getCMVariables();
        return cmVariables.stream().map(VariableWrapper::new).filter(this.isQueryVariable()).map(VariableWrapper::getValue).collect(Collectors.joining());
    }

    private Predicate<VariableWrapper> isQueryVariable() {
        return variable -> variable.hasKeyWith(DB_QUERY_PATTERN);
    }

    @Override
    public EmbeddedQueryJob.Type getType() {
        return EmbeddedQueryJob.Type.JOB_DATABASE_EMBEDDED_QUERY;
    }
}

