/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseSapR3JobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SapStepsAdapter;
import com.bmc.ctmconvert.generated.json.models.job_types.BaseSapR3Job;
import com.bmc.ctmconvert.generated.json.models.job_types.SapR3CreateJob;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.SapStep;
import com.bmc.ctmconvert.generated.json.models.job_types.SpoolListRecipient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SapR3CreateJobAdapter
extends BaseSapR3JobAdapter<SapR3CreateJob.Type> {
    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getReRunFromStep());
        ((List)Optional.ofNullable(this.getSteps()).orElse(new ArrayList())).stream().forEach(step -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(step.toString())));
        Optional.ofNullable(this.getSpoolListRecipient()).ifPresent(it -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(it.toString())));
        return usedVariablesFromStr;
    }

    public SapR3CreateJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseSapR3Job buildBaseSapJob() {
        SapR3CreateJob sapR3CreateJob = new SapR3CreateJob().withSteps(this.getSteps()).withRerunFromStep(this.getReRunFromStep()).withSpoolListRecipient(this.getSpoolListRecipient());
        this.getJobClass().ifPresent(arg_0 -> ((SapR3CreateJob)sapR3CreateJob).setJobClass(arg_0));
        return sapR3CreateJob;
    }

    private SpoolListRecipient getSpoolListRecipient() {
        boolean hasRecipient = Optional.ofNullable(this.schedEntity.getAutoedits().get("%%SAPR3-RECIP_TYPE")).isPresent();
        if (hasRecipient) {
            return new SpoolListRecipient().withRecipientName(this.schedEntity.getAutoedits().get("%%SAPR3-RECIPIENT")).withRecipientType(this.getRecipientType()).withRecipientCopy(this.getIsRecipientCopy()).withRecipientExpress(Boolean.valueOf(SapR3CreateJobAdapter.isSapSelected(this.schedEntity, "%%SAPR3-RECIP_EXPRESS"))).withReciptNoForwarding(Boolean.valueOf(SapR3CreateJobAdapter.isSapSelected(this.schedEntity, "%%SAPR3-RECIP_NO_FORWARDING")));
        }
        return null;
    }

    private Boolean getIsRecipientCopy() {
        String value = this.schedEntity.getVariable("%%SAPR3-RECIP_COPY");
        return Optional.ofNullable(value).map("X"::equals).orElse(null);
    }

    private SpoolListRecipient.RecipientType getRecipientType() {
        String recipientType;
        switch (recipientType = Optional.ofNullable(this.schedEntity.getAutoedits().get("%%SAPR3-RECIP_TYPE")).orElse("B")) {
            case "A": {
                return SpoolListRecipient.RecipientType.EXTERNAL_ADDRESS;
            }
            case "U": {
                return SpoolListRecipient.RecipientType.INTERNET_ADDRESS;
            }
            case "C": {
                return SpoolListRecipient.RecipientType.SHARED_DISTRIBUTION_LIST;
            }
            case "P": {
                return SpoolListRecipient.RecipientType.PRIVATE_DISTRIBUTION_LIST;
            }
            case "F": {
                return SpoolListRecipient.RecipientType.FAX_NUMBER;
            }
            case "L": {
                return SpoolListRecipient.RecipientType.TELEX_NUMBER;
            }
            case "X": {
                return SpoolListRecipient.RecipientType.X_400_ADDRESS;
            }
        }
        return null;
    }

    private String getReRunFromStep() {
        return this.schedEntity.getAutoedits().get("%%SAPR3-RERUN_STEP_NUM");
    }

    @Override
    public SapR3CreateJob.Type getType() {
        return SapR3CreateJob.Type.JOB_SAP_R_3_CREATE;
    }

    private Optional<SapR3CreateJob.JobClass> getJobClass() {
        String jobClass = this.schedEntity.getAutoedits().get("%%SAPR3-JOBCLASS");
        if ("A".equals(jobClass)) {
            return Optional.of(SapR3CreateJob.JobClass.A);
        }
        if ("B".equals(jobClass)) {
            return Optional.of(SapR3CreateJob.JobClass.B);
        }
        return Optional.empty();
    }

    private List<SapStep> getSteps() {
        return new SapStepsAdapter(this.getVariablesAdapter()).getSteps();
    }
}

