/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.FileWatcher;
import java.util.Optional;
import java.util.Set;

public class FileWatcherAdapter
extends BaseJobAdapter<FileWatcher.Type> {
    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariables = this.variablesAdapter.getUsedVariablesFromStr(this.getPath());
        return usedVariables;
    }

    public FileWatcherAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        FileWatcher fileWatcher = new FileWatcher().withType(this.getType()).withPath(this.getPath()).withSearchInterval(this.getSearchInterval()).withTimeLimit(this.getTimeLimit()).withStartTime(this.getStartTime()).withStopTime(this.getStopTime());
        this.getMinimumSize().ifPresent(arg_0 -> ((FileWatcher)fileWatcher).setMinimumSize(arg_0));
        this.getWildcard().ifPresent(arg_0 -> ((FileWatcher)fileWatcher).setWildcard(arg_0));
        this.getMinimalAge().ifPresent(arg_0 -> ((FileWatcher)fileWatcher).setMinimalAge(arg_0));
        this.getMaximalAge().ifPresent(arg_0 -> ((FileWatcher)fileWatcher).setMaximalAge(arg_0));
        return fileWatcher;
    }

    @Override
    public FileWatcher.Type getType() {
        if (this.isDeleteType()) {
            return FileWatcher.Type.JOB_FILE_WATCHER_DELETE;
        }
        return FileWatcher.Type.JOB_FILE_WATCHER_CREATE;
    }

    private boolean isDeleteType() {
        return "DELETE".equals(this.schedEntity.getVariable("%%FileWatch-MODE"));
    }

    private String getPath() {
        return this.schedEntity.getVariable("%%FileWatch-FILE_PATH");
    }

    private String getSearchInterval() {
        return this.schedEntity.getVariable("%%FileWatch-INT_FILE_SEARCHES");
    }

    private String getTimeLimit() {
        return this.schedEntity.getVariable("%%FileWatch-TIME_LIMIT");
    }

    private String getStartTime() {
        return this.schedEntity.getVariable("%%FileWatch-START_TIME");
    }

    private String getStopTime() {
        return this.schedEntity.getVariable("%%FileWatch-STOP_TIME");
    }

    private Optional<String> getMinimumSize() {
        return this.getNonDefaultValue("%%FileWatch-MIN_DET_SIZE", "0").map(this::toJsonUnits);
    }

    private String toJsonUnits(String value) {
        if (value.endsWith("B")) {
            return value;
        }
        return value + "B";
    }

    private Optional<Boolean> getWildcard() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%FileWatch-FILESIZE_WILDCARD")).filter("Y"::equals).map(value -> Boolean.TRUE);
    }

    private Optional<String> getMinimalAge() {
        return this.getNonDefaultValue("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
    }

    private Optional<String> getMaximalAge() {
        return this.getNonDefaultValue("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
    }

    private Optional<String> getNonDefaultValue(String variableName, String defaultValue) {
        return Optional.ofNullable(this.schedEntity.getVariable(variableName)).filter(value -> !value.equals(defaultValue));
    }
}

