/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import com.bmc.ctmconvert.generated.json.models.job_types.FileTransfer;
import com.bmc.ctmconvert.generated.json.models.job_types.FileTransfersItem;
import com.bmc.ctmconvert.generated.json.models.job_types.ItemCommand;
import com.bmc.ctmconvert.generated.json.models.job_types.ItemFileWatcherOptions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileTransferAdapter
extends BaseJobAdapter<FileTransfer.Type> {
    public static final String PRE_SRC_COMMAND = "FTP-PRECOMM1[1-5]";
    public static final String PRE_SRC_ARG1 = "FTP-PREPARAM11[1-5]";
    public static final String PRE_SRC_ARG2 = "FTP-PREPARAM12[1-5]";
    public static final String POST_SRC_COMMAND = "FTP-POSTCOMM1[1-5]";
    public static final String POST_SRC_ARG1 = "FTP-POSTPARAM11[1-5]";
    public static final String POST_SRC_ARG2 = "FTP-POSTPARAM12[1-5]";
    public static final String PRE_DEST_COMMAND = "FTP-PRECOMM2[1-5]";
    public static final String PRE_DEST_ARG1 = "FTP-PREPARAM21[1-5]";
    public static final String PRE_DEST_ARG2 = "FTP-PREPARAM22[1-5]";
    public static final String POST_DEST_COMMAND = "FTP-POSTCOMM2[1-5]";
    public static final String POST_DEST_ARG1 = "FTP-POSTPARAM21[1-5]";
    public static final String POST_DEST_ARG2 = "FTP-POSTPARAM22[1-5]";
    public static final String FILE_TRANSFER_VARIABLE_PREFIX = "FTP-";
    public static final String BASIC_ATTRIBUTES = "LPATH|RPATH|TYPE|UPLOAD";
    public static final String COMMANDS = "PRECOMM|POSTCOMM|PREPARAM|POSTPARAM";
    public static final String FILE_WATCHER_OPTIONS = "MINSIZE|ABSTIME|TIMELIMIT_UNIT|TIMELIMIT|FILE_MIN_AGE|FILE_MAX_AGE|WATCHNAME|TRANSFER_ALL|WATCH_VAR_TYPE";
    public static final String NUMBERS = "[1-5]+";
    public static final String FILE_TRANSFER_OPTION_REGEX = "FTP-UPLOAD[1-5]";

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getConnectionProfileDualEndPoint());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getConnectionProfileSrc()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getConnectionProfileDest()));
        Stream.ofNullable(this.getFileTransfersItems()).flatMap(Collection::stream).forEach(variable -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(variable.toString())));
        Stream.ofNullable(this.getFileTransferVariables()).flatMap(Collection::stream).forEach(variable -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(variable.toString())));
        Set variablesDefinitionFT = Stream.ofNullable(this.getFileTransfersItems()).flatMap(Collection::stream).map(fileTransfersItem -> fileTransfersItem.getFileWatcherOptions()).filter(fileWatcherOption -> Objects.nonNull(fileWatcherOption)).map(fileWatcherOption -> fileWatcherOption.getAssignFileNameToVariable()).collect(Collectors.toSet());
        usedVariablesFromStr.removeAll(variablesDefinitionFT);
        return usedVariablesFromStr;
    }

    public FileTransferAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        FileTransfer fileTransfer = new FileTransfer().withFileTransfers(this.getFileTransfersItems()).withVariables(this.getFileTransferVariables());
        if (this.isSinglePoint()) {
            this.getConnectionProfileSrc().ifPresent(arg_0 -> ((FileTransfer)fileTransfer).setConnectionProfileSrc(arg_0));
            this.getConnectionProfileDest().ifPresent(arg_0 -> ((FileTransfer)fileTransfer).setConnectionProfileDest(arg_0));
        } else if (this.isDualPoint()) {
            this.getConnectionProfileDualEndPoint().ifPresent(arg_0 -> ((FileTransfer)fileTransfer).setConnectionProfileDualEndpoint(arg_0));
        }
        return fileTransfer;
    }

    private List<Variable> getFileTransferVariables() {
        List variables = this.getVariablesAdapter().getCMVariables().stream().map(VariableWrapper::new).filter(variable -> variable.getKey().contains("FTP-OVERRIDE_WATCH_INTERVAL1") || variable.getKey().contains("FTP-WATCH_INTERVAL1")).map(variable -> {
            String keyWithoutPrefix = GlobalFunctions.removeVariablePrefix(variable.getKey());
            return new Variable().withAdditionalProperty(keyWithoutPrefix, (Object)variable.getValue());
        }).collect(Collectors.toList());
        return JsonUtils.getOrNull(variables);
    }

    private boolean isSinglePoint() {
        Optional<String> account = this.getVariablesAdapter().getVariableByName("%%FTP-ACCOUNT");
        return account.map(s -> s.contains("+")).orElse(false);
    }

    private boolean isDualPoint() {
        Optional<String> account = this.getVariablesAdapter().getVariableByName("%%FTP-ACCOUNT");
        return account.filter(s -> !s.contains("+")).isPresent();
    }

    private Optional<String> getConnectionProfileDualEndPoint() {
        return this.getVariablesAdapter().getVariableByName("%%FTP-ACCOUNT");
    }

    private List<FileTransfersItem> getFileTransfersItems() {
        List cmVariables = this.getVariablesAdapter().getCMVariables().stream().map(VariableWrapper::new).collect(Collectors.toList());
        Map<String, List<VariableWrapper>> fileTransferVariables = cmVariables.stream().filter(v -> v.hasKeyWith(Pattern.compile("FTP-(LPATH|RPATH|TYPE|UPLOAD|PRECOMM|POSTCOMM|PREPARAM|POSTPARAM|MINSIZE|ABSTIME|TIMELIMIT_UNIT|TIMELIMIT|FILE_MIN_AGE|FILE_MAX_AGE|WATCHNAME|TRANSFER_ALL|WATCH_VAR_TYPE)[1-5]+"))).collect(Collectors.groupingBy(this.getLastDigit()));
        return fileTransferVariables.values().stream().map(this::toFileTransferItem).collect(Collectors.toList());
    }

    private FileTransfersItem toFileTransferItem(List<VariableWrapper> value) {
        FileTransfersItem fileTransfersItem = new FileTransfersItem();
        this.setFileTransferItemSrc(value, fileTransfersItem);
        this.setFileTransferItemDest(value, fileTransfersItem);
        this.setFileTransferItemType(value, fileTransfersItem);
        this.setFileTransferItemOption(value, fileTransfersItem);
        this.setFileTransferItemCommands(value, fileTransfersItem);
        this.setFileTransferItemFileWatcherOptions(value, fileTransfersItem);
        return fileTransfersItem;
    }

    private void setFileTransferItemFileWatcherOptions(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        if (this.isWithFileWatcherOptions(value)) {
            fileTransfersItem.setFileWatcherOptions(this.createFileWatcherOptions(value));
        }
    }

    private boolean isWithFileWatcherOptions(List<VariableWrapper> value) {
        Optional<String> option = this.getStringFromListByRegex(value, FILE_TRANSFER_OPTION_REGEX);
        return this.getTransferOption(option).map(transferOption -> FileTransfersItem.TransferOption.DEST_TO_SRC_FILE_WATCHER.equals(transferOption) || FileTransfersItem.TransferOption.SRC_TO_DEST_FILE_WATCHER.equals(transferOption) || FileTransfersItem.TransferOption.FILE_WATCHER.equals(transferOption)).orElse(false);
    }

    private ItemFileWatcherOptions createFileWatcherOptions(List<VariableWrapper> value) {
        ItemFileWatcherOptions itemFileWatcherOptions = new ItemFileWatcherOptions();
        this.setFileWatcherOptionsMinSize(value, itemFileWatcherOptions);
        this.setFileWatcherOptionsTimeLimitPolicy(value, itemFileWatcherOptions);
        this.setFileWatcherOptionsTimeLimitValue(value, itemFileWatcherOptions);
        this.setFileWatcherOptionsMinFileAge(value, itemFileWatcherOptions);
        this.setFileWatcherOptionsMaxFileAge(value, itemFileWatcherOptions);
        this.setFileWatcherOptionsAssignFileNameToVariable(value, itemFileWatcherOptions);
        this.setFileWatcherOptionsTransferAllMatchingFiles(value, itemFileWatcherOptions);
        return itemFileWatcherOptions;
    }

    private void setFileWatcherOptionsMinSize(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        Optional<String> minSize = this.getStringFromListByRegex(value, "FTP-MINSIZE[1-5]");
        minSize.ifPresent(arg_0 -> ((ItemFileWatcherOptions)itemFileWatcherOptions).setMinDetectedSizeInBytes(arg_0));
    }

    private void setFileWatcherOptionsTimeLimitPolicy(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        ItemFileWatcherOptions.TimeLimitPolicy policy = null;
        if (this.isPolicyMinutesToWait(value)) {
            policy = ItemFileWatcherOptions.TimeLimitPolicy.MINUTES_TO_WAIT;
        } else if (this.isPolicyWaitUntil(value)) {
            policy = ItemFileWatcherOptions.TimeLimitPolicy.WAIT_UNTIL;
        }
        itemFileWatcherOptions.setTimeLimitPolicy(policy);
    }

    private boolean isPolicyWaitUntil(List<VariableWrapper> value) {
        String policyTypeMinutesToWait = "1";
        return this.isPolicy(value, policyTypeMinutesToWait);
    }

    private boolean isPolicy(List<VariableWrapper> value, String policyTypeMinutesToWait) {
        String policyTypeVariable = this.getStringFromListByRegex(value, "FTP-ABSTIME[1-5]").orElse("");
        return policyTypeMinutesToWait.equals(policyTypeVariable);
    }

    private boolean isPolicyMinutesToWait(List<VariableWrapper> value) {
        String policyTypeMinutesToWait = "0";
        return this.isPolicy(value, policyTypeMinutesToWait);
    }

    private void setFileWatcherOptionsTimeLimitValue(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        Optional<String> timeLimitValue = this.isPolicyMinutesToWait(value) ? this.getMinutesToWait(value) : this.getWaitUntil(value);
        timeLimitValue.ifPresent(arg_0 -> ((ItemFileWatcherOptions)itemFileWatcherOptions).setTimeLimitValue(arg_0));
    }

    private Optional<String> getMinutesToWait(List<VariableWrapper> value) {
        Optional<String> timeUnits = this.getStringFromListByRegex(value, "FTP-TIMELIMIT_UNIT[1-5]");
        Optional<String> timeLimitOption = this.getTimeLimit(value);
        return timeLimitOption.flatMap(timeLimit -> {
            try {
                int timeLimitValue = Integer.parseInt(timeLimit);
                return this.convertXmlTimeToWaitToJson(timeUnits, timeLimitValue);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        });
    }

    private Optional<String> convertXmlTimeToWaitToJson(Optional<String> timeUnits, int timeLimitValue) {
        Optional<String> minutesToWait = this.isTimeUnitsMinutes(timeUnits) ? this.getLimitWhenGivenInMinutes(timeLimitValue) : (this.isTimeUnitsHours(timeUnits) ? this.getLimitWhenGivenInHours(timeLimitValue) : (this.isTimeUnitsSeconds(timeUnits) ? Optional.ofNullable("0") : Optional.empty()));
        return minutesToWait;
    }

    private boolean isTimeUnitsSeconds(Optional<String> timeUnits) {
        return Optional.ofNullable("0").equals(timeUnits);
    }

    private boolean isTimeUnitsHours(Optional<String> timeUnits) {
        return Optional.ofNullable("2").equals(timeUnits);
    }

    private Optional<String> getLimitWhenGivenInHours(int timeLimitValue) {
        return this.getLimitWhenGivenInMinutes(timeLimitValue * 60);
    }

    private Optional<String> getLimitWhenGivenInMinutes(int timeLimitValue) {
        return Optional.ofNullable(String.valueOf(timeLimitValue));
    }

    private boolean isTimeUnitsMinutes(Optional<String> timeUnits) {
        return Optional.ofNullable("1").equals(timeUnits);
    }

    private Optional<String> getWaitUntil(List<VariableWrapper> value) {
        return this.getTimeLimit(value);
    }

    private Optional<String> getTimeLimit(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, "FTP-TIMELIMIT[1-5]");
    }

    private void setFileWatcherOptionsMinFileAge(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        Optional<String> minFileAge = this.getStringFromListByRegex(value, "FTP-FILE_MIN_AGE[1-5]");
        minFileAge.ifPresent(arg_0 -> ((ItemFileWatcherOptions)itemFileWatcherOptions).setMinFileAge(arg_0));
    }

    private void setFileWatcherOptionsMaxFileAge(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        Optional<String> minFileAge = this.getStringFromListByRegex(value, "FTP-FILE_MAX_AGE[1-5]");
        minFileAge.ifPresent(arg_0 -> ((ItemFileWatcherOptions)itemFileWatcherOptions).setMaxFileAge(arg_0));
    }

    private void setFileWatcherOptionsAssignFileNameToVariable(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        Optional<String> fileNameToVariable = this.getStringFromListByRegex(value, "FTP-WATCHNAME[1-5]");
        fileNameToVariable.ifPresent(arg_0 -> ((ItemFileWatcherOptions)itemFileWatcherOptions).setAssignFileNameToVariable(arg_0));
    }

    private void setFileWatcherOptionsTransferAllMatchingFiles(List<VariableWrapper> value, ItemFileWatcherOptions itemFileWatcherOptions) {
        Optional<String> transferAllMatchingFiles = this.getStringFromListByRegex(value, "FTP-TRANSFER_ALL[1-5]");
        Optional<Boolean> shouldTransferAllFiles = this.getTransferAllMatchingFiles(transferAllMatchingFiles);
        shouldTransferAllFiles.ifPresent(arg_0 -> ((ItemFileWatcherOptions)itemFileWatcherOptions).setTransferAllMatchingFiles(arg_0));
    }

    private Optional<Boolean> getTransferAllMatchingFiles(Optional<String> transferAllMatchingFiles) {
        return transferAllMatchingFiles.map(this::convertXmlToJsonTransferAllMatchingFiles);
    }

    private Boolean convertXmlToJsonTransferAllMatchingFiles(String matchingFilesString) {
        Boolean matchingFiles = null;
        if ("1".equals(matchingFilesString)) {
            matchingFiles = true;
        } else if (matchingFilesString != null) {
            matchingFiles = false;
        }
        return matchingFiles;
    }

    private void setFileTransferItemCommands(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        this.setFileTransferItemPreCommandSrc(value, fileTransfersItem);
        this.setFileTransferItemPreCommandDest(value, fileTransfersItem);
        this.setFileTransferItemPostCommandSrc(value, fileTransfersItem);
        this.setFileTransferItemPostCommandDest(value, fileTransfersItem);
    }

    private void setFileTransferItemPreCommandSrc(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        if (this.hasVariable(value, PRE_SRC_COMMAND)) {
            fileTransfersItem.setPreCommandSrc(this.buildItemCommand(this.getPreSrcActionFromVariable(value), this.getPreSrcArg1FromVariable(value), this.getPreSrcArg2FromVariable(value)));
        }
    }

    private Optional<ItemCommand.Action> getPreSrcActionFromVariable(List<VariableWrapper> value) {
        return this.getAction(value, PRE_SRC_COMMAND);
    }

    private Optional<ItemCommand.Action> getAction(List<VariableWrapper> value, String actionVariableRegex) {
        return this.getStringFromListByRegex(value, actionVariableRegex).map(valueOfVariableOptional -> switch (valueOfVariableOptional) {
            case "chmod" -> ItemCommand.Action.CHMOD;
            case "rename" -> ItemCommand.Action.RENAME;
            case "mkdir" -> ItemCommand.Action.MKDIR;
            case "rm" -> ItemCommand.Action.RM;
            case "rmdir" -> ItemCommand.Action.RMDIR;
            default -> null;
        });
    }

    private Optional<String> getPreSrcArg1FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, PRE_SRC_ARG1);
    }

    private Optional<String> getPreSrcArg2FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, PRE_SRC_ARG2);
    }

    private Optional<String> getPostSrcArg1FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, POST_SRC_ARG1);
    }

    private Optional<String> getPostSrcArg2FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, POST_SRC_ARG2);
    }

    private Optional<String> getPreDestArg1FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, PRE_DEST_ARG1);
    }

    private Optional<String> getPreDestArg2FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, PRE_DEST_ARG2);
    }

    private Optional<String> getPostDestArg1FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, POST_DEST_ARG1);
    }

    private Optional<String> getPostDestArg2FromVariable(List<VariableWrapper> value) {
        return this.getStringFromListByRegex(value, POST_DEST_ARG2);
    }

    private boolean hasVariable(List<VariableWrapper> value, String regex) {
        return value.stream().anyMatch(v -> v.hasKeyWith(Pattern.compile(regex)));
    }

    private void setFileTransferItemPreCommandDest(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        if (this.hasVariable(value, PRE_DEST_COMMAND)) {
            fileTransfersItem.setPreCommandDest(this.buildItemCommand(this.getPreDestActionFromVariable(value), this.getPreDestArg1FromVariable(value), this.getPreDestArg2FromVariable(value)));
        }
    }

    private Optional<ItemCommand.Action> getPreDestActionFromVariable(List<VariableWrapper> value) {
        return this.getAction(value, PRE_DEST_COMMAND);
    }

    private void setFileTransferItemPostCommandSrc(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        if (this.hasVariable(value, POST_SRC_COMMAND)) {
            fileTransfersItem.setPostCommandSrc(this.buildItemCommand(this.getPostSrcActionFromVariable(value), this.getPostSrcArg1FromVariable(value), this.getPostSrcArg2FromVariable(value)));
        }
    }

    private ItemCommand buildItemCommand(Optional<ItemCommand.Action> action, Optional<String> arg1, Optional<String> arg2) {
        ItemCommand itemCommand = new ItemCommand();
        action.ifPresent(arg_0 -> ((ItemCommand)itemCommand).setAction(arg_0));
        arg1.ifPresent(arg_0 -> ((ItemCommand)itemCommand).setArg1(arg_0));
        arg2.ifPresent(arg_0 -> ((ItemCommand)itemCommand).setArg2(arg_0));
        return itemCommand;
    }

    private Optional<ItemCommand.Action> getPostSrcActionFromVariable(List<VariableWrapper> value) {
        return this.getAction(value, POST_SRC_COMMAND);
    }

    private void setFileTransferItemPostCommandDest(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        if (this.hasVariable(value, POST_DEST_COMMAND)) {
            fileTransfersItem.setPostCommandDest(this.buildItemCommand(this.getPostDestActionFromVariable(value), this.getPostDestArg1FromVariable(value), this.getPostDestArg2FromVariable(value)));
        }
    }

    private Optional<ItemCommand.Action> getPostDestActionFromVariable(List<VariableWrapper> value) {
        return this.getAction(value, POST_DEST_COMMAND);
    }

    private void setFileTransferItemOption(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        Optional<String> option = this.getStringFromListByRegex(value, FILE_TRANSFER_OPTION_REGEX);
        Optional<FileTransfersItem.TransferOption> transferOption = this.getTransferOption(option);
        transferOption.ifPresent(arg_0 -> ((FileTransfersItem)fileTransfersItem).setTransferOption(arg_0));
    }

    private Optional<FileTransfersItem.TransferOption> getTransferOption(Optional<String> option) {
        return option.map(this::convertXmlTransferOptionToJsonTransferOption);
    }

    private FileTransfersItem.TransferOption convertXmlTransferOptionToJsonTransferOption(String op) {
        return switch (op) {
            case "0" -> FileTransfersItem.TransferOption.DEST_TO_SRC;
            case "2" -> FileTransfersItem.TransferOption.DEST_TO_SRC_FILE_WATCHER;
            case "3" -> FileTransfersItem.TransferOption.SRC_TO_DEST_FILE_WATCHER;
            case "4" -> FileTransfersItem.TransferOption.FILE_WATCHER;
            default -> FileTransfersItem.TransferOption.SRC_TO_DEST;
        };
    }

    private void setFileTransferItemType(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        Optional<String> type = this.getStringFromListByRegex(value, "FTP-TYPE[1-5]");
        FileTransfersItem.TransferType transferType = null;
        if ("A".equals(type.orElse(""))) {
            transferType = FileTransfersItem.TransferType.ASCII;
        } else if ("I".equals(type.orElse(""))) {
            transferType = FileTransfersItem.TransferType.BINARY;
        }
        fileTransfersItem.setTransferType(transferType);
    }

    private void setFileTransferItemDest(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        Optional<String> dest = this.getStringFromListByRegex(value, "FTP-RPATH[1-5]");
        dest.ifPresent(arg_0 -> ((FileTransfersItem)fileTransfersItem).setDest(arg_0));
    }

    private void setFileTransferItemSrc(List<VariableWrapper> value, FileTransfersItem fileTransfersItem) {
        Optional<String> src = this.getStringFromListByRegex(value, "FTP-LPATH[1-5]");
        src.ifPresent(arg_0 -> ((FileTransfersItem)fileTransfersItem).setSrc(arg_0));
    }

    private Optional<String> getStringFromListByRegex(List<VariableWrapper> value, String srcRegex) {
        return value.stream().filter(v -> v.hasKeyWith(Pattern.compile(srcRegex))).map(VariableWrapper::getValue).findFirst();
    }

    private Function<VariableWrapper, String> getLastDigit() {
        return v -> v.getKey().substring(v.getKey().length() - 1);
    }

    private Optional<String> getConnectionProfileDest() {
        return this.getVariablesAdapter().getVariableByName("%%FTP-RHOST");
    }

    @Override
    public FileTransfer.Type getType() {
        return FileTransfer.Type.JOB_FILE_TRANSFER;
    }

    private Optional<String> getConnectionProfileSrc() {
        return this.getVariablesAdapter().getVariableByName("%%FTP-LHOST");
    }
}

