/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.conditions;

import com.bmc.ctmconvert.common.conditions.AndOr;
import com.bmc.ctmconvert.common.conditions.Condition;
import com.bmc.ctmconvert.common.conditions.Op;
import java.util.Map;
import java.util.Properties;

public class InCondition
extends Condition {
    static final String CLOSE_BRACKET = ")";
    static final String OPEN_BRACKET = "(";
    private String andOr;
    private Op op;

    public InCondition(String condName, String andStr, String odate) {
        super(condName, odate);
        this.andOr = andStr;
    }

    public InCondition(String condName, String andStr, String odate, Op op) {
        this(condName, andStr, odate);
        this.setOp(op);
    }

    public InCondition(String condName, String andStr, String odate, String op) {
        this(condName, andStr, odate);
        this.setOp(op);
    }

    public InCondition(String condName, AndOr andOr, String odate, Op op) {
        this(condName, andOr.toString(), odate, op);
    }

    public String getAndOr() {
        return this.andOr;
    }

    public void setAndOr(String andOr) {
        this.andOr = andOr;
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public void setOp(String op) {
        this.op = this.getOpFromString(op);
    }

    private Op getOpFromString(String op) {
        if (op == null) {
            return Op.NoOp;
        }
        if (op.trim().equals(CLOSE_BRACKET)) {
            return Op.Close;
        }
        if (op.trim().equals(OPEN_BRACKET)) {
            return Op.Open;
        }
        return Op.NoOp;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)super.getProperties());
        properties.put("AND_OR", this.andOr);
        if (this.hasOp()) {
            properties.put("OP", this.op.toString());
        }
        return properties;
    }

    public boolean hasOp() {
        return this.op != null && !this.op.equals((Object)Op.NoOp);
    }

    public static InCondition createInCondition(Properties properties) throws UnMatchPropertiesException {
        String condName = properties.getProperty("NAME");
        String odate = properties.getProperty("ODATE");
        String andOr = properties.getProperty("AND_OR");
        String opStr = properties.getProperty("OP");
        if (condName == null || odate == null || andOr == null) {
            throw new UnMatchPropertiesException();
        }
        return new InCondition(condName, andOr, odate, opStr);
    }

    @Override
    public String toString() {
        return "InCondition [andOr=" + this.andOr + ", op=" + String.valueOf((Object)this.op) + ", toString()=" + super.toString() + "]";
    }

    public static class UnMatchPropertiesException
    extends Exception {
    }
}

