/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.calendars;

import com.bmc.ctmconvert.generated.json.models.Calendar.Periodic.Period;
import com.bmc.ctmconvert.generated.json.models.Calendar.Periodic.When;
import com.bmc.ctmconvert.generated.json.models.Calendar.Periodic.Year;
import java.time.Month;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PeriodicCalendarWhenConverter {
    private final List<Properties> calendarProperties;

    public PeriodicCalendarWhenConverter(List<Properties> calendarProperties) {
        this.calendarProperties = calendarProperties;
    }

    public When convert() {
        PeriodData periodData = new PeriodData();
        this.calendarProperties.forEach(data -> {
            String year = data.getProperty("NAME");
            String days = data.getProperty("DAYS");
            Map<Month, List<String>> byMonth = this.splitByMonth(days, year);
            this.setPeriods(periodData, byMonth, year);
        });
        if (periodData.hasPeriods()) {
            return new When().withPeriods(periodData.toPeriods());
        }
        return null;
    }

    private Map<Month, List<String>> splitByMonth(String days, String year) {
        List<YearMonth> yearMonths = this.calculateLengthOfMonthFor(year);
        EnumMap<Month, List<String>> byMonth = new EnumMap<Month, List<String>>(Month.class);
        int prevMonthLength = 0;
        for (YearMonth month : yearMonths) {
            Month monthName = month.getMonth();
            int lengthOfMonth = month.lengthOfMonth();
            String forMonth = days.substring(prevMonthLength, lengthOfMonth + prevMonthLength);
            List<String> periodList = this.stringToPeriodList(forMonth);
            byMonth.put(monthName, periodList);
            prevMonthLength += lengthOfMonth;
        }
        return byMonth;
    }

    private List<String> stringToPeriodList(String forMonth) {
        return forMonth.chars().mapToObj(c -> Character.toString((char)c)).collect(Collectors.toList());
    }

    List<YearMonth> calculateLengthOfMonthFor(String year) {
        return IntStream.range(1, 13).mapToObj(month -> YearMonth.of(Integer.parseInt(year), month)).collect(Collectors.toList());
    }

    private void setPeriods(PeriodData periodData, Map<Month, List<String>> byMonth, String year) {
        byMonth.forEach((month, days) -> {
            for (int i = 0; i < days.size(); ++i) {
                String period = (String)days.get(i);
                String day = String.valueOf(i + 1);
                periodData.setPeriod(period, year, (Month)month, day);
            }
        });
    }

    private static class PeriodData {
        private final Map<String, Map<String, Map<Month, List<String>>>> data = new HashMap<String, Map<String, Map<Month, List<String>>>>();
        private final Collection<String> periods = new HashSet<String>();

        public boolean hasPeriods() {
            return !this.periods.isEmpty();
        }

        public void setPeriod(String periodName, String year, Month month, String day) {
            if (this.isEmptyPeriod(periodName)) {
                return;
            }
            this.periods.add(periodName);
            Map yearData = this.data.computeIfAbsent(periodName, p -> new HashMap());
            Map monthData = yearData.computeIfAbsent(year, y -> new EnumMap(Month.class));
            List days = monthData.computeIfAbsent(month, m -> new ArrayList());
            days.add(day);
        }

        public List<Period> toPeriods() {
            return this.periods.stream().map(this::getPeriodFor).collect(Collectors.toList());
        }

        private Period getPeriodFor(String periodName) {
            return new Period().withPeriod(periodName).withYears(this.getYearsFor(periodName));
        }

        private List<Year> getYearsFor(String periodName) {
            Map<String, Map<Month, List<String>>> years = this.data.get(periodName);
            return years.entrySet().stream().map(yearEntry -> {
                String yearName = (String)yearEntry.getKey();
                Map days = (Map)yearEntry.getValue();
                Year year = new Year().withYear(yearName);
                return this.setMonths(year, days);
            }).collect(Collectors.toList());
        }

        private Year setMonths(Year year, Map<Month, List<String>> months) {
            months.forEach((month, days) -> {
                List sortedDays = days.stream().sorted().collect(Collectors.toList());
                this.setterByMonth(year, (Month)month).accept(sortedDays);
            });
            return year;
        }

        private Consumer<List<String>> setterByMonth(Year year, Month month) {
            switch (month) {
                case JANUARY: {
                    return arg_0 -> ((Year)year).withJan(arg_0);
                }
                case FEBRUARY: {
                    return arg_0 -> ((Year)year).withFeb(arg_0);
                }
                case MARCH: {
                    return arg_0 -> ((Year)year).withMar(arg_0);
                }
                case APRIL: {
                    return arg_0 -> ((Year)year).withApr(arg_0);
                }
                case MAY: {
                    return arg_0 -> ((Year)year).withMay(arg_0);
                }
                case JUNE: {
                    return arg_0 -> ((Year)year).withJun(arg_0);
                }
                case JULY: {
                    return arg_0 -> ((Year)year).withJul(arg_0);
                }
                case AUGUST: {
                    return arg_0 -> ((Year)year).withAug(arg_0);
                }
                case SEPTEMBER: {
                    return arg_0 -> ((Year)year).withSep(arg_0);
                }
                case OCTOBER: {
                    return arg_0 -> ((Year)year).withOct(arg_0);
                }
                case NOVEMBER: {
                    return arg_0 -> ((Year)year).withNov(arg_0);
                }
            }
            return arg_0 -> ((Year)year).withDec(arg_0);
        }

        private boolean isEmptyPeriod(String period) {
            return period.equals(" ");
        }
    }
}

