/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.calendars;

import com.bmc.ctmconvert.vc.FieldValidation;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CtmCalendar {
    public static final String THE_NOT_PREFIX_IN_CALENDAR_NAME = "not-";
    private final String name;
    private final String ctmName;
    private String description = null;
    private final SortedMap<Integer, YearDays> allYears = new TreeMap<Integer, YearDays>();

    public CtmCalendar(String name, String ctmName) {
        this.name = name;
        this.ctmName = ctmName;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CtmCalendar that = (CtmCalendar)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.ctmName, that.ctmName) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.allYears, that.allYears);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.ctmName, this.getDescription(), this.allYears);
    }

    public boolean isDaySet(int year, int month, int day) {
        return this.allYears.containsKey(year) && ((YearDays)this.allYears.get(year)).contains(month, day);
    }

    public void addDay(int year, int month, int day) {
        YearDays yearDays = this.allYears.computeIfAbsent(year, YearDays::new);
        yearDays.add(year, month, day);
    }

    public void removeDay(int year, int month, int day) {
        YearDays yearDays = this.allYears.computeIfAbsent(year, YearDays::new);
        yearDays.remove(month, day);
    }

    public void invertDay(int year, int month, int day) {
        YearDays yearDays = this.allYears.computeIfAbsent(year, YearDays::new);
        if (yearDays.contains(month, day)) {
            yearDays.remove(month, day);
        } else {
            yearDays.add(year, month, day);
        }
    }

    public Optional<CalendarData> getCalendarData(boolean negative) {
        if (this.allYears.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.toCalendarData(negative));
    }

    private CalendarData toCalendarData(boolean negative) {
        StringBuilder name2Use = new StringBuilder();
        if (negative) {
            name2Use.append(THE_NOT_PREFIX_IN_CALENDAR_NAME);
            this.addImpliedYears();
        }
        name2Use.append(this.name);
        String nameStr = FieldValidation.instance().validateAndReturnFixedValue("DAYSCAL", name2Use.toString());
        CalendarData data = new CalendarData();
        data.dataCenter = this.ctmName;
        data.name = nameStr;
        data.years = this.allYears.values().stream().map(yearDays -> {
            CalendarData.YearData yearData = new CalendarData.YearData();
            yearData.year = yearDays.year;
            yearData.days = yearDays;
            yearData.description = this.getDescription((YearDays)yearDays, negative);
            return yearData;
        }).collect(Collectors.toList());
        return data;
    }

    private String getDescription(YearDays curYear, boolean negative) {
        String desc;
        String string = desc = this.description == null ? String.format("This is year %d", curYear.year) : this.description;
        if (negative) {
            desc = String.format("Complementary Cal of \"%s\"-\"%s\"", this.name, desc);
        }
        desc = this.validateDesLength(desc);
        return desc;
    }

    private String validateDesLength(String desc) {
        if (desc.length() > 50) {
            desc = desc.substring(0, 49);
        }
        return desc;
    }

    private void addImpliedYears() {
        ArrayList<Integer> yearsList = new ArrayList<Integer>(this.allYears.keySet());
        Collections.sort(yearsList);
        for (int i = 0; i < yearsList.size() && i < yearsList.size() - 1; ++i) {
            int gapSize = (Integer)yearsList.get(i + 1) - (Integer)yearsList.get(i);
            for (int j = 1; gapSize > 1 && j < gapSize; ++j) {
                this.allYears.put((Integer)yearsList.get(i) + j, new YearDays((Integer)yearsList.get(i) + j));
            }
        }
    }

    public void setDescription(String description) {
        this.description = this.validateDesLength(description);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getDcName() {
        return this.ctmName;
    }

    public static CtmCalendar createAllDaysCalendar(String calendarName, String dataCenter) {
        CtmCalendar toRetCtmCalendar = new CtmCalendar(calendarName, dataCenter);
        Calendar current = Calendar.getInstance();
        current.set(5, 1);
        current.set(2, 0);
        current.add(1, -5);
        int stopYear = current.get(1) + 10;
        while (current.get(1) < stopYear) {
            toRetCtmCalendar.addDay(current.get(1), current.get(2) + 1, current.get(5));
            current.add(5, 1);
        }
        return toRetCtmCalendar;
    }

    public static class YearDays {
        private final int year;
        private final Map<Integer, Set<Integer>> daysInMonth;
        private static final DateTimeFormatter VALID_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-M-d").withResolverStyle(ResolverStyle.STRICT);

        public YearDays(int year) {
            this.year = year;
            this.daysInMonth = new HashMap<Integer, Set<Integer>>();
        }

        public boolean contains(int month, int day) {
            return this.getOrDefault(month).contains(day);
        }

        private Set<Integer> getOrDefault(int month) {
            return this.daysInMonth.getOrDefault(month, new HashSet());
        }

        public void add(int year, int month, int day) {
            if (this.isValidDate(year, month, day)) {
                Set<Integer> days = this.getOrDefault(month);
                days.add(day);
                this.daysInMonth.put(month, days);
            }
        }

        private boolean isValidDate(int year, int month, int day) {
            try {
                String dateString = String.format("%d-%d-%d", year, month, day);
                LocalDate.parse(dateString, VALID_DATE_FORMATTER);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }

        public void remove(int month, int day) {
            this.getOrDefault(month).remove(day);
        }

        @NotNull
        public ArrayList<Integer> getByMonth(int month, boolean isNegative) {
            int monthOfYear = month + 1;
            Set<Integer> daysInCurrentMonth = this.getOrDefault(monthOfYear);
            if (isNegative) {
                LocalDate firstOfMonth = LocalDate.of(this.year, monthOfYear, 1);
                Stream<LocalDate> allMonthDays = firstOfMonth.datesUntil(firstOfMonth.plusMonths(1L));
                Set negativeDays = allMonthDays.map(LocalDate::getDayOfMonth).filter(day -> !daysInCurrentMonth.contains(day)).collect(Collectors.toSet());
                return new ArrayList<Integer>(negativeDays);
            }
            return new ArrayList<Integer>(daysInCurrentMonth);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            YearDays yearDays = (YearDays)o;
            return this.year == yearDays.year && Objects.equals(this.daysInMonth, yearDays.daysInMonth);
        }

        public int hashCode() {
            return this.year;
        }
    }

    public static class CalendarData {
        public List<YearData> years;
        public String name;
        public String dataCenter;

        public static class YearData {
            public int year;
            public String description;
            public YearDays days;
        }
    }
}

