/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.TableModel;

public class Table
implements Serializable {
    private static final long serialVersionUID = -3201515432421062187L;
    private Vector<Vector<String>> table;
    private int Nrows;
    private int Ncolumns;

    public Table() {
        this.init();
    }

    public Table(Table t) {
        this.init();
        for (int i = 0; i < t.getRowCount(); ++i) {
            Vector<String> row = new Vector<String>();
            for (int j = 0; j < t.getColumnCount(); ++j) {
                row.add(t.getValueAt(i, j));
            }
            this.addRow(row);
        }
    }

    public Table(TableModel t) {
        this.init();
        for (int i = 0; i < t.getRowCount(); ++i) {
            Vector<String> row = new Vector<String>();
            for (int j = 0; j < t.getColumnCount(); ++j) {
                row.add((String)t.getValueAt(i, j));
            }
            this.addRow(row);
        }
    }

    public Table(ArrayList<String> data) {
        this.init();
        for (int i = 0; i < data.size(); ++i) {
            Vector<String> row = new Vector<String>();
            row.add(data.get(i));
            this.addRow(row);
        }
    }

    public void init() {
        this.table = new Vector();
        this.Nrows = 0;
        this.Ncolumns = 0;
    }

    public int getColumnCount() {
        return this.Ncolumns;
    }

    public int getRowCount() {
        return this.Nrows;
    }

    public String getValueAt(int row, int column) {
        return this.table.get(row).elementAt(column);
    }

    public void addRow(Vector<String> row) {
        if (row.size() > this.Ncolumns) {
            this.Ncolumns = row.size();
        }
        this.table.add(row);
        ++this.Nrows;
    }

    public void addRow(String ... data) {
        Vector<String> row = new Vector<String>();
        for (String item : data) {
            row.add(item);
        }
        this.addRow(row);
    }

    public Vector<Vector<String>> getRows() {
        return this.table;
    }

    public void addRow(ArrayList<String> colomnList) {
        Vector<String> row = new Vector<String>();
        for (String item : colomnList) {
            row.add(item);
        }
        this.addRow(row);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getRowCount(); ++i) {
            builder.append("{");
            if (this.hasValueAt(i, 0)) {
                builder.append(this.getValueAt(i, 0));
            }
            for (int j = 1; j < this.getColumnCount(); ++j) {
                if (!this.hasValueAt(i, j)) continue;
                builder.append("," + this.getValueAt(i, j));
            }
            builder.append("}");
        }
        return builder.toString();
    }

    public boolean hasValueAt(int row, int column) {
        return row >= 0 && row < this.getRowCount() && column >= 0 && column < this.getColumnCount();
    }

    public String[][] to2DArray() {
        String[][] ret = new String[this.Nrows][this.Ncolumns];
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 1; j < this.getColumnCount(); ++j) {
                if (!this.hasValueAt(i, j)) continue;
                ret[i][j] = this.getValueAt(i, j);
            }
        }
        return ret;
    }

    public Table copy() {
        return new Table(this);
    }
}

