/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.common.message_id.MessageIdSaas;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.util.HashMap;

public class MessageIdTable
extends CsvFile {
    private HashMap<String, MessageId> m_messageIds = new HashMap();
    private static MessageIdTable m_instance = null;

    private MessageIdTable() {
        this.load(Globs.DATA_DIR + Globs.DIRSEP + "MessageId.csv");
    }

    public static MessageIdTable instance() {
        if (m_instance == null) {
            m_instance = new MessageIdTable();
        }
        return m_instance;
    }

    public HashMap<String, MessageId> getMessageIds() {
        return this.m_messageIds;
    }

    @Override
    protected void handleRecord(IAttrHolder message_entry, int record_number) {
        MessageId message_id = this.createMessageId(message_entry);
        String hashKey = message_entry.getAttr("MSGID");
        this.m_messageIds.put(hashKey, message_id);
    }

    private MessageId createMessageId(IAttrHolder message_entry) {
        if (SettingsBooleanKeys.isSaas()) {
            return new MessageIdSaas(message_entry);
        }
        return new MessageId(message_entry);
    }

    public static void destroy() {
        m_instance = null;
    }
}

