/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SelfConversionCLIInternalExceptionHandler;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ExceptionHandler {
    private static File exceptionFile = null;
    private static final String HEADER = "Exception file";
    private static final String SELF_CONVERSION_CLI_HEADER = "Self Conversion CLI Exception file";
    private static IExceptionHandler exceptionHandler = null;
    private static IExceptionHandler selfConversionCliexceptionHandler = null;

    public static void initExceptionFile() {
        String exceptionFileName = Globs.EXCEPTION_FILE;
        exceptionFile = new File(Globs.LOGS_DIR + exceptionFileName + ".txt");
        exceptionHandler = new InternalExceptionHandler();
        exceptionHandler.writeToExceptionFile(HEADER);
    }

    public static void initSelfConversionCLIExceptionFile() {
        selfConversionCliexceptionHandler = new SelfConversionCLIInternalExceptionHandler();
        selfConversionCliexceptionHandler.writeToExceptionFile(SELF_CONVERSION_CLI_HEADER);
    }

    public static void writeToExceptionFile(String message) {
        if (exceptionHandler == null) {
            ExceptionHandler.initExceptionFile();
        }
        exceptionHandler.writeToExceptionFile(message);
    }

    public static void writeToExceptionFile(Exception e) {
        if (exceptionHandler == null) {
            ExceptionHandler.initExceptionFile();
        }
        exceptionHandler.writeToExceptionFile(e);
    }

    public static void writeToSelfConversionCliExceptionFile(Exception e) {
        selfConversionCliexceptionHandler.writeToExceptionFile(e);
    }

    public static void writeToSelfConversionCliExceptionFile(String message) {
        selfConversionCliexceptionHandler.writeToExceptionFile(message);
    }

    public static String getStackTrace(Exception e) {
        return exceptionHandler.getStackTrace(e);
    }

    public static void setExceptionHandler(IExceptionHandler newExceptionHandler) {
        exceptionHandler = newExceptionHandler;
    }

    private static class InternalExceptionHandler
    implements IExceptionHandler {
        private InternalExceptionHandler() {
        }

        @Override
        public void writeToExceptionFile(String message) {
            String timeString = GlobalFunctions.getCurrentDateByFormat("yyyy-MM-dd HH:mm:ss");
            try {
                BufferedWriter fileBW = new BufferedWriter(new FileWriter(exceptionFile, true));
                fileBW.write(timeString + "\n" + message);
                fileBW.write("\n");
                fileBW.write("*************************************************");
                fileBW.write("\n");
                fileBW.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void writeToExceptionFile(Exception e) {
            this.writeToExceptionFile(this.getStackTrace(e));
            if (e instanceof ConvertorException) {
                try {
                    String entityHandled = " EntitCurrenty id";
                    if (((ConvertorException)e).isCurrentEntityCompleted()) {
                        entityHandled = "Last handled Entity id";
                    }
                    BufferedWriter fileBW = new BufferedWriter(new FileWriter(exceptionFile, true));
                    fileBW.write("\n");
                    fileBW.write("*************************************************");
                    String failureMessage = "\n" + entityHandled + "\t:" + ((ConvertorException)e).getCurrentEntity() + "\nState\t\t\t:" + ((ConvertorException)e).getCurrentEntityState() + "\n";
                    fileBW.write(failureMessage);
                    fileBW.write("Error cause\t\t:" + ((ConvertorException)e).getError() + "\n");
                    fileBW.write("*************************************************\n");
                    fileBW.write("\n");
                    fileBW.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }

        @Override
        public String getStackTrace(Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            return sw.toString();
        }
    }

    public static interface IExceptionHandler {
        public void writeToExceptionFile(String var1);

        public void writeToExceptionFile(Exception var1);

        public String getStackTrace(Exception var1);
    }

    private static class NullExceptionHandler
    extends InternalExceptionHandler {
        private NullExceptionHandler() {
        }

        @Override
        public void writeToExceptionFile(String message) {
        }

        @Override
        public void writeToExceptionFile(Exception e) {
        }

        @Override
        public String getStackTrace(Exception e) {
            return "";
        }
    }
}

