/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.interfaces.VariableResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoEditsConcatenator {
    private Pattern variablePattern;
    private String concatenationPlaceHolder = "BMCTOKEN";

    public AutoEditsConcatenator(Pattern specificVendorVarsPattern) {
        this.variablePattern = specificVendorVarsPattern;
    }

    public Pattern getVariablePattern() {
        return this.variablePattern;
    }

    public String concat(String workingVar) {
        StringBuffer result = new StringBuffer();
        Matcher m = this.variablePattern.matcher(workingVar);
        while (m.find()) {
            m.appendReplacement(result, Matcher.quoteReplacement(m.group(1) + "."));
        }
        m.appendTail(result);
        return result.toString();
    }

    public String concat(String workingVar, VariableResolver resolver) {
        String result = workingVar;
        Matcher m = this.variablePattern.matcher(workingVar);
        while (m.find()) {
            String resolvedVar;
            String matchVarName = m.group(1);
            if (matchVarName.equals(resolvedVar = resolver.resolve(matchVarName))) continue;
            result = result.replace(m.group(0), resolvedVar + this.concatenationPlaceHolder);
            m.reset(result);
        }
        result = result.replaceAll(this.concatenationPlaceHolder, ".");
        return result;
    }
}

