/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.table.CollectionUtils;
import com.bmc.ctmconvert.base.table.DistinctColumnItem;
import com.bmc.ctmconvert.base.table.ITableFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TableFilterState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Set<DistinctColumnItem>> data = new HashMap<Integer, Set<DistinctColumnItem>>();

    TableFilterState() {
    }

    public void clear(int column) {
        this.data.remove(column);
    }

    public void clear() {
        this.data.clear();
    }

    private Set<DistinctColumnItem> prepareValueSet(int column) {
        Set<DistinctColumnItem> vals = this.data.get(column);
        if (vals == null) {
            vals = new HashSet<DistinctColumnItem>();
            this.data.put(column, vals);
        }
        return vals;
    }

    public void addValue(int column, DistinctColumnItem value) {
        this.prepareValueSet(column).add(value);
    }

    public void addValues(int column, Collection<DistinctColumnItem> values) {
        this.prepareValueSet(column).addAll(values);
    }

    public void setValues(int column, Collection<DistinctColumnItem> values) {
        this.data.remove(column);
        if (!CollectionUtils.isEmpty(values)) {
            this.prepareValueSet(column).addAll(values);
        }
    }

    public Collection<DistinctColumnItem> getValues(int column) {
        Set<DistinctColumnItem> vals = this.data.get(column);
        return vals == null ? Collections.emptySet() : vals;
    }

    public boolean include(ITableFilter.Row entry) {
        for (int col = 0; col < entry.getValueCount(); ++col) {
            Collection<DistinctColumnItem> values = this.getValues(col);
            if (CollectionUtils.isEmpty(values) || values.contains(new DistinctColumnItem(entry.getValue(col), 0))) continue;
            return false;
        }
        return true;
    }
}

