/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.table.CheckListFilterType;
import com.bmc.ctmconvert.base.table.DefaultObjectToStringTranslator;
import com.bmc.ctmconvert.base.table.ICheckListModel;
import com.bmc.ctmconvert.base.table.IObjectToStringTranslator;
import com.bmc.ctmconvert.base.table.IValueWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;

public class DefaultCheckListModel<T>
extends AbstractListModel
implements ICheckListModel<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> data = new ArrayList<T>();
    private final Set<T> checks = new HashSet<T>();
    public static IObjectToStringTranslator DEFAULT_TRANSLATOR = new DefaultObjectToStringTranslator();
    private List<T> filteredData = null;

    public DefaultCheckListModel(Collection<? extends T> data) {
        if (data == null) {
            return;
        }
        for (T object : data) {
            this.data.add(object);
            this.checks.clear();
        }
    }

    public DefaultCheckListModel(T ... data) {
        this((Collection<T>)Arrays.asList(data));
    }

    @Override
    public int getSize() {
        return this.data().size();
    }

    private List<T> data() {
        return this.filteredData == null ? this.data : this.filteredData;
    }

    public Object getElementAt(int index) {
        return this.data().get(index);
    }

    @Override
    public boolean isCheckedIndex(int index) {
        return this.checks.contains(this.data().get(index));
    }

    @Override
    public void setCheckedIndex(int index, boolean value) {
        T o = this.data().get(index);
        if (value) {
            this.checks.add(o);
        } else {
            this.checks.remove(o);
        }
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public Collection<T> getCheckedItems() {
        ArrayList<T> items = new ArrayList<T>(this.checks);
        items.retainAll(this.data);
        return Collections.unmodifiableList(items);
    }

    @Override
    public void setCheckedItems(Collection<T> items) {
        ArrayList<T> correctedItems = new ArrayList<T>(items);
        correctedItems.retainAll(this.data);
        this.checks.clear();
        this.checks.addAll(correctedItems);
        this.fireContentsChanged(this, 0, this.checks.size() - 1);
    }

    @Override
    public void filter(String filter, IObjectToStringTranslator translator, CheckListFilterType filterType) {
        if (filter == null || filter.trim().length() == 0) {
            this.filteredData = null;
        } else {
            CheckListFilterType ft = filterType == null ? CheckListFilterType.CONTAINS : filterType;
            IObjectToStringTranslator t = translator == null ? DEFAULT_TRANSLATOR : translator;
            String f = filter.toLowerCase();
            ArrayList<T> fData = new ArrayList<T>();
            for (T o : this.data) {
                T value = o instanceof IValueWrapper ? ((IValueWrapper)o).getValue() : o;
                if (!ft.include(t.translate(value), f)) continue;
                fData.add(o);
            }
            this.filteredData = fData;
        }
        this.fireContentsChanged(this, 0, this.data.size() - 1);
    }
}

