/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.table.BaseFilterableTableColumnPopup;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.base.table.FilterTableHeaderRenderer;
import com.bmc.ctmconvert.base.table.IFilterChangeListener;
import com.bmc.ctmconvert.base.table.ITableFilter;
import com.bmc.ctmconvert.base.table.JTableFilter;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BaseFilterableTable {
    private JTable jTable;
    private JScrollPane jScrollPane;
    private JPanel jPanel;
    private boolean filterable;
    private BaseFilterableTableColumnPopup filterPopup;
    private ITableFilter<?> filter;

    public BaseFilterableTable() {
        this.jTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int Index_row, int Index_col) {
                Component component = super.prepareRenderer(renderer, Index_row, Index_col);
                if (BaseFilterableTable.this.jTable.isEnabled()) {
                    component.setForeground(FlowGlobals.ConversionBlack);
                } else {
                    component.setForeground(FlowGlobals.ConversionDisableColor);
                }
                if (this.isCellSelected(Index_row, Index_col) && BaseFilterableTable.this.jTable.isEnabled()) {
                    component.setBackground(new Color(8832748));
                    component.setForeground(FlowGlobals.ConversionWhite);
                } else if (Index_row % 2 == 0) {
                    component.setBackground(new Color(0xEBEBEB));
                } else {
                    component.setBackground(FlowGlobals.ConversionWhite);
                }
                return component;
            }
        };
        this.initialize();
    }

    public BaseFilterableTable(JTable jTable) {
        this.jTable = jTable;
        this.initialize();
    }

    private void initialize() {
        this.jTable.setColumnSelectionAllowed(false);
        this.jTable.setFillsViewportHeight(true);
        this.jTable.setSelectionMode(0);
        this.jTable.setIntercellSpacing(new Dimension(3, 0));
        this.jTable.setRowHeight(20);
        this.jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.filterable = true;
        if (this.filterable) {
            this.filter = new JTableFilter(this.jTable);
            this.filterPopup = new BaseFilterableTableColumnPopup(this.filter);
            this.filterPopup.setEnabled(true);
            this.filterPopup.setSearchable(true);
            Object table = this.filter.getTable();
            this.filter.addChangeListener(new IFilterChangeListener(){
                final /* synthetic */ JTable val$table;
                {
                    this.val$table = jTable;
                }

                @Override
                public void filterChanged(ITableFilter<?> filter) {
                    this.val$table.getTableHeader().repaint();
                }
            });
            this.setupHeaderRenderers(((JTable)table).getModel(), true);
        }
        this.jScrollPane = new JScrollPane(this.jTable);
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout());
        this.jPanel.add((Component)this.jScrollPane, "Center");
    }

    private void setupHeaderRenderers(TableModel newModel, boolean fullSetup) {
        Object table = this.filter.getTable();
        ((JTable)table).getTableHeader().setReorderingAllowed(false);
        FilterTableHeaderRenderer headerRenderer = new FilterTableHeaderRenderer(this.filter);
        this.filter.modelChanged(newModel);
        for (TableColumn c : Collections.list(((JTable)table).getColumnModel().getColumns())) {
            c.setHeaderRenderer(headerRenderer);
        }
        if (!fullSetup) {
            return;
        }
        ((Container)table).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                BaseFilterableTable.this.setupHeaderRenderers((TableModel)e.getNewValue(), false);
            }
        });
    }

    public void setHeight(int height) {
        this.jPanel.setPreferredSize(new Dimension(0, height));
    }

    public void setEnabled(boolean b) {
        this.jTable.setEnabled(b);
        this.jTable.getTableHeader().setEnabled(b);
        this.filterPopup.setEnabled(b);
    }

    public void setModel(DefaultTableModel model) {
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (BaseFilterableTable.this.jTable.getRowCount() == 1) {
                    BaseFilterableTable.this.jTable.getSelectionModel().clearSelection();
                    BaseFilterableTable.this.jTable.setRowSelectionInterval(0, 0);
                }
            }
        });
        this.jTable.setModel(model);
    }

    public void setModel(BaseTableModel model) {
        this.jTable.setModel(model);
    }

    public void setColumnWidth(int column, int width) {
        this.jTable.getColumnModel().getColumn(column).setMinWidth(width);
        this.jTable.getColumnModel().getColumn(column).setMaxWidth(width);
    }

    public void addSelectionListener(ListSelectionListener x) {
        this.jTable.getSelectionModel().addListSelectionListener(x);
    }

    public int getSelectedRowIndex() {
        return this.jTable.getSelectedRow();
    }

    public Object[] getSelectedRow() {
        int selectedIndex = this.jTable.getSelectedRow();
        Object[] selectedRow = null;
        if (selectedIndex != -1) {
            int columnCount = this.jTable.getColumnCount();
            selectedRow = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                selectedRow[i] = this.jTable.getValueAt(selectedIndex, i);
            }
        }
        return selectedRow;
    }

    public void removeRow(int index) {
        int currentSelection;
        ((DefaultTableModel)this.jTable.getModel()).removeRow(this.jTable.convertRowIndexToModel(index));
        int n = currentSelection = this.jTable.getRowCount() > index ? index : index - 1;
        if (this.jTable.getRowCount() > 0) {
            this.jTable.setRowSelectionInterval(currentSelection, currentSelection);
        }
    }

    public int getRowCount() {
        return this.jTable.getRowCount();
    }

    public Component getComponent() {
        return this.jPanel;
    }

    public void setCellEditor(int column, JComboBox editor) {
        this.jTable.getColumnModel().getColumn(column).setCellEditor(new DefaultCellEditor(editor));
        this.jTable.getColumnModel().getColumn(column).setCellRenderer(new TableCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cellRenderer = table.getCellRenderer(row, 0).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JComboBox<Object> editorView = new JComboBox<Object>(new Object[]{value});
                editorView.setBorder(null);
                editorView.setBackground(cellRenderer.getBackground());
                editorView.setForeground(cellRenderer.getForeground());
                return editorView;
            }
        });
    }
}

