/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BaseTextField
extends BaseComponent
implements FocusListener,
DocumentListener {
    private JTextField jTextField;
    private JLabel validityMessageImage;
    private Border border;
    private boolean firstTime = true;

    public BaseTextField() {
        this.jTextField = new JTextField();
        this.initialize();
    }

    public BaseTextField(String text) {
        this.jTextField = new JTextField(text);
        this.setText(text);
        this.initialize();
    }

    public BaseTextField(BaseFieldValidator validator) {
        this.jTextField = new JTextField();
        this.validator = validator;
        this.initialize();
    }

    public BaseTextField(String text, BaseFieldValidator validator) {
        this.jTextField = new JTextField(text);
        this.validator = validator;
        this.initialize();
    }

    public BaseTextField(String componentName, String componentGroup) {
        this.componentName = componentName;
        this.componentGroup = componentGroup;
        this.jTextField = new JTextField();
        this.initialize();
    }

    private void initialize() {
        this.jTextField.setBorder(FlowGlobals.fieldTextGapDefaultBorder);
        this.jTextField.setPreferredSize(FlowGlobals.fieldSize);
        this.jTextField.addFocusListener(this);
        this.jTextField.getDocument().addDocumentListener(this);
        this.jTextField.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.validityMessageImage = new JLabel(FlowGlobals.FIELD_VALIDATION_ERROR_ICON);
        this.validityMessageImage.setVisible(false);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.jTextField.getDocument().addDocumentListener(listener);
    }

    public void addKeyListener(KeyListener l) {
        this.jTextField.addKeyListener(l);
    }

    public String getText() {
        return this.getText(true);
    }

    public String getText(boolean trim) {
        return trim ? this.jTextField.getText().trim() : this.jTextField.getText();
    }

    public void setText(String text) {
        this.jTextField.setText(text);
        this.isValid();
    }

    public void setEnabled(boolean enabled) {
        this.jTextField.setEnabled(enabled);
        this.jTextField.setBackground(enabled ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
    }

    public void setSize(Dimension d) {
        this.jTextField.setSize(d);
    }

    public void setBorder(Border border) {
        this.border = border;
        this.jTextField.setBorder(border);
    }

    public void setEditable(boolean b) {
        this.jTextField.setEditable(b);
        this.jTextField.setBackground(b ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
    }

    @Override
    public void setValidConstrain() {
        if (this.jTextField.getText() != null && !this.jTextField.getText().isEmpty()) {
            this.validator.setValidConstrain(this.jTextField.getText());
        }
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.validator != null) {
            valid = this.validator.isValid(this.jTextField.getText());
        }
        this.setValid(valid);
        return valid;
    }

    @Override
    public void setValidityLook(boolean valid) {
        if (this.disableValidityLook) {
            this.jTextField.setBorder(this.jTextField.hasFocus() ? FlowGlobals.fieldTextGapSelectedBorder : FlowGlobals.fieldTextGapDefaultBorder);
            return;
        }
        if (this.border == null) {
            this.jTextField.setBorder(valid ? (this.jTextField.hasFocus() ? FlowGlobals.fieldTextGapSelectedBorder : FlowGlobals.fieldTextGapDefaultBorder) : FlowGlobals.fieldTextGapInvalidBorder);
        }
        if (this.validator != null) {
            this.validityMessageImage.setVisible(!valid);
            this.validityMessageImage.setToolTipText(valid ? "" : this.validator.getErrorMessage());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.border == null && (this.isValid || this.firstTime)) {
            this.jTextField.setBorder(FlowGlobals.fieldTextGapSelectedBorder);
            this.firstTime = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public Component getComponent() {
        return this.jTextField;
    }

    @Override
    public Component getValidityComponent() {
        return this.validityMessageImage;
    }

    public void setFieldLimit(int limit) {
        String tmp = this.getText();
        this.jTextField.setDocument(new JTextFieldLimit(limit));
        this.jTextField.getDocument().addDocumentListener(this);
        this.setText(tmp);
    }

    @Override
    public void setError(Boolean b, String Message2) {
        this.setValid(b == false);
        this.setValidityLook(b == false);
        this.validityMessageImage.setVisible(b);
        this.validityMessageImage.setToolTipText(b == false ? "" : Message2);
        if (this.border == null) {
            this.jTextField.setBorder(!b.booleanValue() ? (this.jTextField.hasFocus() ? FlowGlobals.fieldTextGapSelectedBorder : FlowGlobals.fieldTextGapDefaultBorder) : FlowGlobals.fieldTextGapInvalidBorder);
        }
    }

    @Override
    public Object getData() {
        return this.getText();
    }

    @Override
    public void setData(Object obj) {
        if (!(obj instanceof String)) {
            return;
        }
        this.setText((String)obj);
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.STRING;
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        final Actionable tmpAction = action;
        this.jTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                tmpAction.act();
            }
        });
    }

    public void setValidator(BaseFieldValidator validator) {
        this.validator = validator;
        this.initialize();
    }

    public void setFocus() {
        this.jTextField.requestFocusInWindow();
    }

    private class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int limit;

        public JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

