/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BaseSplitPane
extends BaseComponent {
    public static int VERTICAL_SPLIT = 0;
    public static int HORIZONTAL_SPLIT = 1;
    private JSplitPane jSplitPane;
    private int dividerSize = 6;
    private int dividerDefaultLocation = 200;

    public BaseSplitPane(int newOrientation) {
        this.jSplitPane = new JSplitPane(newOrientation);
        this.initialize();
    }

    public BaseSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this.jSplitPane = new JSplitPane(newOrientation, newLeftComponent, newRightComponent);
        this.initialize();
        this.initializeDividerStyle();
    }

    private void initialize() {
        this.jSplitPane.setDividerLocation(this.dividerDefaultLocation);
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerSize(this.dividerSize);
    }

    private void initializeDividerStyle() {
        for (int i = 0; i < this.jSplitPane.getComponentCount(); ++i) {
            if (!(this.jSplitPane.getComponent(i) instanceof BasicSplitPaneDivider)) continue;
            ((BasicSplitPaneDivider)this.jSplitPane.getComponent(i)).setBackground(FlowGlobals.wrapperBackgroundColor);
        }
    }

    public void setComponent(Component comp, ComponentPosition position) {
        switch (position.ordinal()) {
            case 0: 
            case 2: {
                this.jSplitPane.setLeftComponent(comp);
                break;
            }
            case 1: 
            case 3: {
                this.jSplitPane.setRightComponent(comp);
                break;
            }
        }
        if (this.jSplitPane.getLeftComponent() != null && this.jSplitPane.getRightComponent() != null) {
            this.jSplitPane.setDividerSize(this.dividerSize);
            this.jSplitPane.setDividerLocation(200);
            this.initializeDividerStyle();
        } else {
            this.jSplitPane.setDividerSize(0);
        }
    }

    public void setDividerLocation(int location) {
        this.jSplitPane.setDividerLocation(location);
    }

    public void setDividerVisibility(boolean aFlag) {
        this.jSplitPane.setDividerLocation(aFlag ? this.dividerDefaultLocation : 0);
        ((BasicSplitPaneUI)this.jSplitPane.getUI()).getDivider().setVisible(aFlag);
    }

    @Override
    public Component getComponent() {
        return this.jSplitPane;
    }

    public static enum ComponentPosition {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

