/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class BaseReportRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private String filter;
    private int matchOffset;
    private JTextField filterInput;
    protected String label;

    public BaseReportRenderer() {
        this.setTextSelectionColor(FlowGlobals.ConversionWhite);
        this.setBackgroundSelectionColor(new Color(8832748));
        this.setBorderSelectionColor(new Color(8832748));
    }

    public void setFilterInput(JTextField filter) {
        this.filterInput = filter;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.filterInput != null) {
            this.filter = this.filterInput.getText().trim().toLowerCase();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.label = node.getUserObject().toString();
            this.matchOffset = this.filter.length() > 0 && this.label.toLowerCase().contains(this.filter) && !sel ? this.label.toLowerCase().indexOf(this.filter) : -1;
        }
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.matchOffset > -1) {
            int start = this.getLabelStart();
            String preMatch = this.label.substring(0, this.matchOffset);
            if (this.matchOffset < 0) {
                throw new RuntimeException();
            }
            if (this.filter.length() < 1) {
                throw new RuntimeException();
            }
            String matchPart = this.label.substring(this.matchOffset, this.matchOffset + this.filter.length());
            int preWidth = g.getFontMetrics().stringWidth(preMatch);
            int matchWidth = g.getFontMetrics().stringWidth(matchPart);
            g.setColor(Color.yellow);
            g.fillRect(start + preWidth, 0, matchWidth, this.getHeight());
            g.setColor(this.getTextNonSelectionColor());
            Rectangle rect = g.getFontMetrics().getStringBounds(matchPart, g).getBounds();
            g.drawString(matchPart, start + preWidth + 1, -rect.y);
        }
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }
}

