/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.ExceptionHandler;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BaseLinkLabel
extends BaseComponent {
    private JLabel jLabel;
    public static final String BOLD = "BOLD";
    private String uri;
    private MouseAdapter mouseAdapter;
    private MouseListener mouseListener;

    public BaseLinkLabel(String uri, String text) {
        this.uri = uri;
        this.jLabel = new JLabel(text);
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                BaseLinkLabel.this.jLabel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        };
        this.jLabel.addMouseListener(this.mouseListener);
        this.initialize();
    }

    public BaseLinkLabel(String text, Icon icon) {
        this.jLabel = new JLabel(text, icon, 2);
        this.jLabel.setIconTextGap(8);
        this.initialize();
    }

    public BaseLinkLabel(String text, Font font) {
        this.jLabel = new JLabel(text);
        this.jLabel.setFont(font);
        this.initialize();
    }

    private void initialize() {
        this.jLabel.setPreferredSize(new Dimension(160, 18));
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(new URI(BaseLinkLabel.this.uri));
                    }
                    catch (IOException | URISyntaxException ex) {
                        ExceptionHandler.writeToExceptionFile(ex);
                    }
                }
            }
        };
        this.jLabel.addMouseListener(this.mouseAdapter);
    }

    public void setText(String text) {
        this.jLabel.setText(text);
    }

    public void setIcon(Icon icon) {
        this.jLabel.setIcon(icon);
    }

    public void setIconTextGap(int iconTextGap) {
        this.jLabel.setIconTextGap(iconTextGap);
    }

    public void setFont(Font font) {
        this.jLabel.setFont(font);
    }

    @Override
    public JComponent getComponent() {
        return this.jLabel;
    }

    public MouseAdapter getMosueAdapter() {
        return this.mouseAdapter;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }
}

